/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  sleep示例程序
 *        程序运行如下：
 *        1. 上电完成初始化操作后，LED1亮3S灭1S
 *        2. 进入主循环，LED1亮1S灭1S，进入深睡眠
 *        唤醒源：
 *        1. PINT
 *        2. KINT
 *
 *        连线：
 *        PINT：PA1
 *        KINT：PA3
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

void timedelay(uint32_t delaytime)
{
    uint32_t temp = delaytime * 10000;

    while (temp--);
}

int main(void)
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();
    User_SysTickInit();

    GPIOInit();
    /* 配置唤醒源PINT、KINT、IWDT及LED1，初始化完成后LED亮3S灭1S */
    KINTx_Init();
    PINTx_Init();

    LightInit(LED1_PIN);
    LightOn(LED1_PIN);
    Delay_100us(30000);
    LightOff(LED1_PIN);
    Delay_100us(10000);

    while (1)
    {
        LightOn(LED1_PIN);
        Delay_100us(10000);
        LightOff(LED1_PIN);
        Delay_100us(10000);
        /* 深睡 */
        deep_sleep();
    }
}


/*************************END OF FILE**********************/
