/*********************************************************
*Copyright (C), 2019, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  timer.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块程序头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "timer.h"
#include "string.h"


/*********************************************************
函数名: void T16N_Pin_Init(void)
描  述: T16Nx输出管脚初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N_Pin_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));
	
    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Output;
    x.Func = GPIO_Reuse_Func2;
    x.ODE = GPIO_ODE_Output_Disable;
    x.DS = GPIO_DS_Output_Normal;
    x.PUE = GPIO_PUE_Input_Enable;
    x.PDE = GPIO_PDE_Input_Disable;

    /* T16N0(PA4、PA5) */
    GPIO_Init(GPIO_Pin_A4, &x);
    GPIO_Init(GPIO_Pin_A5, &x);

    /* T16N3(PA6、PA7) */
    x.Func = GPIO_Reuse_Func3;
    GPIO_Init(GPIO_Pin_A6, &x);
    GPIO_Init(GPIO_Pin_A7, &x);
}

/*********************************************************
函数名: void T16NxInit(void)
描  述: T16Nx定时器初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16NxInit(void)
{
    T16Nx_BaseInitStruType x;
    T16Nx_PWMInitStruType z;
	SCU_TIMEREN_Typedef t16n_mul_en;
    t16n_mul_en.Word = 0;
	memset(&x, 0, sizeof(x));
	memset(&z, 0, sizeof(z));

    /* 初始化T16Nx定时器:不分频*/
    x.T16Nx_ClkS = T16Nx_ClkS_PCLK;
    x.T16Nx_SYNC = Disable;
    x.T16Nx_EDGE = T16Nx_EDGE_Rise;
    x.T16Nx_Mode = T16Nx_Mode_PWM;
    x.T16Nx_PREMAT = 0x01;          /* 预分频比1:1 */
    /* 初始化定时器T16N0、T16N3 */
    T16Nx_BaseInit(T16N0, &x);
    T16Nx_BaseInit(T16N3, &x);

    /* 配置T16Nx通道输出:同步模式输出 */
    z.T16Nx_MOE0 = Enable;
    z.T16Nx_MOE1 = Enable;
    z.T16Nx_POL0 = POSITIVE;
    z.T16Nx_POL1 = POSITIVE;
    z.T16Nx_PWMMODE = T16Nx_PWMMode_SYNC;
    z.PWMDZE = Disable;
    z.REGBUFEN = Enable;
    T16Nx_PMWOutInit(T16N0, &z);
    T16Nx_PMWOutInit(T16N3, &z);

    T16Nx_MAT0ITConfig(T16N0, T16Nx_Go_No);
    T16Nx_MAT1ITConfig(T16N0, T16Nx_Go_No);
    T16Nx_MAT0Out0Config(T16N0, T16Nx_Out_High);
    T16Nx_MAT1Out0Config(T16N0, T16Nx_Out_Low);
    T16Nx_SetCNT0(T16N0, 0);
    T16Nx_SetMAT0(T16N0, 800);
    T16Nx_SetMAT1(T16N0, 1200);
    T16Nx_SetTOP0(T16N0, 2000);

    T16Nx_MAT0ITConfig(T16N3, T16Nx_Go_No);
    T16Nx_MAT1ITConfig(T16N3, T16Nx_Go_No);
    T16Nx_MAT0Out0Config(T16N3, T16Nx_Out_High);
    T16Nx_MAT1Out0Config(T16N3, T16Nx_Out_Low);
    T16Nx_SetCNT0(T16N3, 0);
    T16Nx_SetMAT0(T16N3, 600);
    T16Nx_SetMAT1(T16N3, 1400);
    T16Nx_SetTOP0(T16N3, 2000);

    /* 使能T16N0、T16N3中断 */
    T16Nx_ITConfig(T16N0, T16Nx_IT_TOP0, Enable);
    NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_1, Enable);
    T16Nx_ITConfig(T16N3, T16Nx_IT_TOP0, Enable);
    NVIC_Init(NVIC_T16N3_IRQn, NVIC_Priority_1, Enable);

    /* 初始化输出管脚 */
    T16N_Pin_Init();

    /* SCU同步启动T16N0、T16N3 */
    t16n_mul_en.T16N0EN = Enable;
    t16n_mul_en.T16N3EN = Enable;
    SCU_MultTimerEnable(t16n_mul_en);

    return;
}


/*************************END OF FILE**********************/
