/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.01
 * @日  期:  2022/07/25
 * @描  述:  Timer模块程序头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{

}


/*********************************************************
函数名: void T16N0_IRQHandler(void)
描  述: T16N0中断处理函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N0_IRQHandler(void)
{
    if ((T16Nx_GetFlagStatus(T16N0, T16Nx_IT_MAT1) == SET) && (T16Nx_GetITStatus(T16N0, T16Nx_IT_MAT1) == SET))
    {
        T16Nx_ClearITPendingBit(T16N0, T16Nx_IT_MAT1);
    }

    if ((T16Nx_GetFlagStatus(T16N0, T16Nx_IT_MAT3) == SET) && (T16Nx_GetITStatus(T16N0, T16Nx_IT_MAT3) == SET))
    {
        T16Nx_ClearITPendingBit(T16N0, T16Nx_IT_MAT3);
    }
}

/*********************************************************
函数名: void T16N1_IRQHandler(void)
描  述: T16N1中断处理函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N1_IRQHandler(void)
{
    if ((T16Nx_GetFlagStatus(T16N1, T16Nx_IT_MAT1) == SET) && (T16Nx_GetITStatus(T16N1, T16Nx_IT_MAT1) == SET))
    {
        T16Nx_ClearITPendingBit(T16N1, T16Nx_IT_MAT1);
    }
}

/*********************************************************
函数名: void PINT1_IRQHandler(void)
描  述: 端口中断处理函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void PINT1_IRQHandler(void)
{
    if ((PINT_GetITFlag(GPIO_Pin_A1) == SET) && (PINT_GetITStatus(GPIO_Pin_A1) == SET) && (PINT_GetPMASK(GPIO_Pin_A1) != SET))
    {
        static uint8_t tri_time = 0x0U;

        PINT_ClearITFlag(GPIO_Pin_A1);      /* 清除端口中断标志位 */

        if (tri_time % 2 == 0)
        {
            T16Nx_SetMAT2(T16N0, dutytab[1]);
            T16Nx_SetMAT3(T16N0, dutytab[4]);
            T16Nx_SetTOP1(T16N0, dutytab[4]);

            T16Nx_SetMAT0(T16N1, dutytab[1]);
            T16Nx_SetMAT1(T16N1, dutytab[4]);
            T16Nx_SetTOP0(T16N1, dutytab[4]);

            GPIO_WriteBit(GPIO_Pin_B1, 1);
        }
        else
        {
            T16Nx_SetMAT2(T16N0, dutytab[1]);
            T16Nx_SetMAT3(T16N0, dutytab[2]);
            T16Nx_SetTOP1(T16N0, dutytab[2]);

            T16Nx_SetMAT0(T16N1, dutytab[1]);
            T16Nx_SetMAT1(T16N1, dutytab[2]);
            T16Nx_SetTOP0(T16N1, dutytab[2]);

            GPIO_WriteBit(GPIO_Pin_B1, 0);
        }

        tri_time++;
    }
}


/*************************END OF FILE**********************/
