/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  gpio.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  外部端口中断配置程序
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "gpio.h"
#include "string.h"

/***************************************************************
 函数名：void PINTx_Init(void)
 描  述：端口中断初始化函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void PINTx_Init(void)
{
    GPIO_InitSettingType x;
    PINT_InitSettingType y;
	memset(&x, 0, sizeof(x));
	memset(&y, 0, sizeof(y));

    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Input;
    x.Func = GPIO_Reuse_Func0;
    x.PUE = GPIO_PUE_Input_Disable;
    x.PDE = GPIO_PDE_Input_Enable;
    GPIO_Init(GPIO_Pin_A1, &x);

    y.IE_Set = PINT_IE_Set_Enable;
    y.Trigger_Style = PINT_Trigger_Rising_Edge;
    PINT_Init(GPIO_Pin_A1, &y);
    NVIC_Init(NVIC_PINT1_IRQn, NVIC_Priority_1, Enable);

    return;
}

/***************************************************************
 函数名：void OutPutRefPin_Init(void)
 描  述：参考输出端口初始化
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void OutPutRefPin_Init(void)
{
    GPIO_InitSettingType x;
	memset(&x, 0, sizeof(x));

    x.Signal = GPIO_Pin_Signal_Digital;
    x.Dir = GPIO_Direction_Output;
    x.Func = GPIO_Reuse_Func0;
    x.PUE = GPIO_PUE_Input_Disable;
    x.PDE = GPIO_PDE_Input_Enable;
    x.ODE = GPIO_ODE_Output_Disable;
    x.DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIO_Pin_B1, &x);

    GPIO_WriteBit(GPIO_Pin_B1, 0);

    return;
}


/*************************END OF FILE**********************/
