/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  irqhandler.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{

}

/*********************************************************
函数名: void T16N2_IRQHandler(void)
描  述: T16N2中断处理函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N2_IRQHandler(void)
{
    if ((T16Nx_GetFlagStatus(T16N2, T16Nx_IT_MAT1) == SET) && (T16Nx_GetITStatus(T16N2, T16Nx_IT_MAT1) == SET))
    {
        T16Nx_ClearITPendingBit(T16N2, T16Nx_IT_MAT1);
    }
}

/*********************************************************
函数名: void T16N3_IRQHandler(void)
描  述: T16N3定时中断函数
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16N3_IRQHandler(void)
{
    if ((T16Nx_GetFlagStatus(T16N3, T16Nx_IT_MAT0) == SET) && (T16Nx_GetITStatus(T16N3, T16Nx_IT_MAT0) == SET))
    {
        static uint8_t s_count = 0x0U;

        T16Nx_ClearITPendingBit(T16N3, T16Nx_IT_MAT0);

        s_count++;

        if (s_count >= 4)
        {
            s_count = 0;
            g_1s_flag = 1;
        }
    }

    return;
}

/*********************************************************
函数名: void ADC_IRQHandler(void)
描  述: ADC中断处理
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void ADC_IRQHandler()
{
    if ((ADC_GetIFStatus(ADC_IF) == SET) && (ADC_GetIEStatus(ADC_IE) == SET))
    {
        g_ad_result = ADC_GetConvValue();
        ADC_ClearIFStatus(ADC_IF);
    }
}


/*************************END OF FILE**********************/
