/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  PWM触发ADC示例程序
          T16N2输出同步PWM波形，使用PWM调制模式触发ADC，将ADC的结果通过UART发送到上位机
          连线：
          PA10 - T16N2_0
          PA11 - T16N2_1
          PB9 - ADC
          PA22 - RXD
          PA23 - TXD
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

volatile uint32_t g_ad_result;
volatile uint8_t  g_1s_flag;

int main(void)
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();
    DeviceClockAllEnable();

    UARTInit();
    ADCInit();

    T16N2Init();
    T16N3Init();

    while (1)
    {
        if (g_1s_flag == 1)
        {
            g_1s_flag = 0x0;
            UARTSendData(g_ad_result);
        }
    }
}


/*************************END OF FILE**********************/
