/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  IIC模块例程
          本程序为主机程序，负责发起写和读。向从机中发送9字节数据后再读回。
          连线：
          PA4 - SCL
          PA5 - SDA
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


#include "main.h"

uint8_t rxbuf[9];
uint8_t txbuf[9];

int main()
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();                               /* 配置时钟 */
    DeviceClockAllEnable();                     /* 打开所有外设时钟 */
    User_SysTickInit();

    IICMasterInitPins();

    while (1)
    {
        IICReadBuf(SLAVE_ADDR, rxbuf, 9);
        memcpy(txbuf, rxbuf, 9);
        Delay_10us(200000);
        IICWriteBuf(SLAVE_ADDR, txbuf, 9);
        Delay_10us(200000);
    }
}


/*************************END OF FILE**********************/

