/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @ļ:  main.h
 * @  :  AE Team
 * @  :  V1.01
 * @  :  2022/07/25
 * @  :  IICʾͷļ
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#include "irqhandler.h"


/***************************************************************
***************************************************************/
uint8_t rxcnt;
uint8_t txcnt;


/***************************************************************
***************************************************************/
void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{

}


/***************************************************************
 : void I2C0_IRQHandler(void)
   IICжϺ
         ûҪٴʱʹòĴķ
 ֵ
 ֵ
 ֵ
***************************************************************/
void I2C0_IRQHandler(void)
{
    /* յʼλ+ַƥ+Ӧλ */
    if ((IIC_GetITStatus(I2C0, IIC_IT_SR) == SET) && (IIC_GetFlagStatus(I2C0, IIC_IF_SR) == SET))
    {
        IIC_ClearITPendingBit(I2C0, IIC_CLR_SR);

        if (IIC_GetRWMode(I2C0) == IIC_Mode_Read)
        {
            txcnt = 0x0U;

            IIC_ClearITPendingBit(I2C0, IIC_CLR_NA);
            IIC_ClearITPendingBit(I2C0, IIC_CLR_TIDLE);
            IIC_ITConfig(I2C0, IIC_IT_RB, Disable);
            IIC_ITConfig(I2C0, IIC_IT_TIDLE, Enable);
        }
        else if (IIC_GetRWMode(I2C0) == IIC_Mode_Write)
        {
            rxcnt = 0x0U;

            IIC_ClearITPendingBit(I2C0, IIC_CLR_NA);
            IIC_ITConfig(I2C0, IIC_IT_RB, Enable);
            IIC_ITConfig(I2C0, IIC_IT_TIDLE, Disable);
        }
    }

    /* ж */
    if ((IIC_GetITStatus(I2C0, IIC_IT_RB) == SET) && (IIC_GetFlagStatus(I2C0, IIC_IF_RB) == SET))
    {
        g_buf[rxcnt++] = IIC_RecByte(I2C0);
    }

    /* ж */
    if ((IIC_GetITStatus(I2C0, IIC_IT_TIDLE) == SET) && (IIC_GetFlagStatus(I2C0, IIC_IF_TIDLE) == SET))
    {
        IIC_ClearITPendingBit(I2C0, IIC_CLR_TIDLE);

        if (IIC_GetFlagStatus(I2C0, IIC_IF_NA) != SET)
        {
            IIC_SendByte(I2C0, g_buf[txcnt++]);
        }
    }

    /* յʼλ+ַƥ+Ӧλ */
    if ((IIC_GetITStatus(I2C0, IIC_IT_SP) == SET) && (IIC_GetFlagStatus(I2C0, IIC_IF_SP) == SET)) /* յλ */
    {
        rxcnt = 0x0U;
        txcnt = 0x0U;

        IIC_ClearITPendingBit(I2C0, IIC_CLR_SP);
        IIC_ClearITPendingBit(I2C0, IIC_CLR_NA);

        IIC_ITConfig(I2C0, IIC_IT_RB, Disable);
        IIC_ITConfig(I2C0, IIC_IT_TIDLE, Disable);
    }
}


/*************************END OF FILE**********************/
