/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  IIC模块例程
          本程序为主机程序，负责发起写和读。从从机中读取9字节数据后，然后发给从机。
          连线：
          PA4 - SCL
          PA5 - SDA
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */



#include "main.h"

int main()
{
    uint8_t wbuf[9];
    uint8_t rbuf[9] ;

    HRC_Config(Enable, SCU_HRC_48M, Enable);    /* 配置HRC时钟频率 */
    SystemInit();                               /* 配置时钟 */
    DeviceClockAllEnable();                     /* 打开所有外设时钟 */
    IICMasterInit();

    User_SysTickInit();

    while (1)
    {
        IICReadBuf(SLAVE_ADDR, rbuf, 9);
        Delay_1ms(2000);
        memcpy(wbuf, rbuf, 9);
        IICWriteBuf(SLAVE_ADDR, wbuf, 9);
        Delay_1ms(2000);
    }

}


/*************************END OF FILE**********************/

