/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2027/07/25
 * @描  述:  ADC演示主程序
          硬件控制ADC，采用10位分辨率，通过UART0将采样的平均值发出
          连线：
          PA22 - TXD
          PA23 - RXD
          PB9  - AD
          使用本例程时，可连接通用开发板HRSDK-GMB-01
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 

#include "main.h"

uint16_t meanvalue;

int main()
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);
    SystemInit();
    DeviceClockAllEnable();
    User_SysTickInit();

    UARTInit();
    ADCInit();

    while (1)
    {
        Delay_100us(10000);
        meanvalue = ADCRead();
        UARTSendData(meanvalue);
    }
}


/*************************END OF FILE**********************/
