/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:  main.c
 * @作  者:  AE Team
 * @版  本:  V1.00
 * @日  期:  2022/07/25
 * @描  述:  ADC演示主程序
          自动转换比较功能，采用12位分辨率，当转换结果不在阈值范围内将点亮LED1，采样的平均值通过UART0发出
          连线：
          PA22 - TXD
          PA23 - RXD
          PB9  - AD
          使用本例程时，可连接通用开发板HRSDK-GMB-01
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          25 July 2022    AE Team         change license to Apache-2.0
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
 
#include "main.h"

int main()
{
    HRC_Config(Enable, SCU_HRC_48M, Enable);
    SystemInit();
    DeviceClockAllEnable();
    User_SysTickInit();

    /* 初始化UART、ADC及LED */
    UARTInit();
    ADCInit();
    LightInit(LED1_PIN);

    /* 配置自动比较功能，启动ADC */
    ADCACPConfig();
    ADC_Start();

    while (1)
    {
        Delay_100us(10000);
        UARTSendData(meanvalue);
    }
}

 
/*************************END OF FILE**********************/
