/***************************************************************
 *文件名：lib_gpio_func_es8p5066.h
 *作 者： AE Team
 *版 本： V1.00
 *日 期： 2023/12/13
 *描 述： ES8P5066 GPIO数字外设管脚复用功能定义头文件
 *备 注：
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************/
#ifndef __LIB_GPIO_FUNC_ES8P5066_H__
#define __LIB_GPIO_FUNC_ES8P5066_H__

/* PA1 */
typedef enum
{
	FUNC_PA1 = 0x00,
	FUNC_PA1_BUZ = 0x01,
} FUNC_TYPE_PA1;

/* PA2 */
typedef enum
{
	FUNC_PA2 = 0x00,
	FUNC_PA2_T16N_BK0 = 0x01,
	FUNC_PA2_T32N0_0 = 0x02,
	FUNC_PA2_NSS1 = 0x03,
} FUNC_TYPE_PA2;

/* PA3 */
typedef enum
{
	FUNC_PA3 = 0x00,
	FUNC_PA3_T16N_BK1 = 0x01,
	FUNC_PA3_T32N0_1 = 0x02,
	FUNC_PA3_SCK1 = 0x03,
} FUNC_TYPE_PA3;

/* PA4 */
typedef enum
{
	FUNC_PA4 = 0x00,
	FUNC_PA4_SCL0 = 0x01,
	FUNC_PA4_T16N0_1 = 0x02,
	FUNC_PA4_MISO1 = 0x03,
} FUNC_TYPE_PA4;

/* PA5 */
typedef enum
{
	FUNC_PA5 = 0x00,
	FUNC_PA5_SDA0 = 0x01,
	FUNC_PA5_T16N0_0 = 0x02,
	FUNC_PA5_MOSI1 = 0x03,
} FUNC_TYPE_PA5;

/* PA6 */
typedef enum
{
	FUNC_PA6 = 0x00,
	FUNC_PA6_T32N0_1 = 0x01,
	FUNC_PA6_T16N0_0 = 0x02,
	FUNC_PA6_T16N3_1 = 0x03,
} FUNC_TYPE_PA6;

/* PA7 */
typedef enum
{
	FUNC_PA7 = 0x00,
	FUNC_PA7_T32N0_0 = 0x01,
	FUNC_PA7_T16N0_1 = 0x02,
	FUNC_PA7_T16N3_0 = 0x03,
} FUNC_TYPE_PA7;

/* PA8 */
typedef enum
{
	FUNC_PA8 = 0x00,
	FUNC_PA8_RXD1 = 0x01,
	FUNC_PA8_T16N1_0 = 0x02,
	FUNC_PA8_TXD2 = 0x03,
} FUNC_TYPE_PA8;

/* PA9 */
typedef enum
{
	FUNC_PA9 = 0x00,
	FUNC_PA9_TXD1 = 0x01,
	FUNC_PA9_T16N1_1 = 0x02,
	FUNC_PA9_CLKO0 = 0x03,
} FUNC_TYPE_PA9;

/* PA10 */
typedef enum
{
	FUNC_PA10 = 0x00,
	FUNC_PA10_T16N2_0 = 0x01,
	FUNC_PA10_T16N3_0 = 0x02,
	FUNC_PA10_SDA0 = 0x03,
} FUNC_TYPE_PA10;

/* PA11 */
typedef enum
{
	FUNC_PA11 = 0x00,
	FUNC_PA11_T16N2_1 = 0x01,
	FUNC_PA11_T16N3_1 = 0x02,
	FUNC_PA11_T16N0_0 = 0x03,
} FUNC_TYPE_PA11;

/* PA12 */
typedef enum
{
	FUNC_PA12 = 0x00,
	FUNC_PA12_RXD2 = 0x02,
	FUNC_PA12_T16N0_1 = 0x03,
} FUNC_TYPE_PA12;

/* PA13 */
typedef enum
{
	FUNC_PA13 = 0x00,
	FUNC_PA13_TXD1 = 0x01,
	FUNC_PA13_TXD2 = 0x02,
	FUNC_PA13_T16N1_1 = 0x03,
} FUNC_TYPE_PA13;

/* PA14(ISCK) */
typedef enum
{
	FUNC_PA14 = 0x00,
	FUNC_PA14_T16N_BK0 = 0x01,
	FUNC_PA14_T16N2_0 = 0x02,
	FUNC_PA14_NSS1 = 0x03,
} FUNC_TYPE_PA14;

/* PA15(ISDA) */
typedef enum
{
	FUNC_PA15 = 0x00,
	FUNC_PA15_SCL0 = 0x01,
	FUNC_PA15_T16N2_1 = 0x02,
	FUNC_PA15_MISO1 = 0x03,
} FUNC_TYPE_PA15;

/* PA16 */
typedef enum
{
	FUNC_PA16 = 0x00,
	FUNC_PA16_T16N0_0 = 0x01,
	FUNC_PA16_T16N_BK2 = 0x02,
	FUNC_PA16_CLKO1 = 0x03,
} FUNC_TYPE_PA16;

/* PA22 */
typedef enum
{
	FUNC_PA22 = 0x00,
	FUNC_PA22_RXD0 = 0x01,
	FUNC_PA22_T16N0_1 = 0x02,
	FUNC_PA22_SDA0 = 0x03,
} FUNC_TYPE_PA22;

/* PA23 */
typedef enum
{
	FUNC_PA23 = 0x00,
	FUNC_PA23_TXD0 = 0x01,
	FUNC_PA23_T16N2_1 = 0x02,
} FUNC_TYPE_PA23;

/* PA24 */
typedef enum
{
	FUNC_PA24 = 0x00,
	FUNC_PA24_MOSI1 = 0x01,
	FUNC_PA24_RXD0 = 0x02,
	FUNC_PA24_T16N1_0 = 0x03,
} FUNC_TYPE_PA24;

/* PA25 */
typedef enum
{
	FUNC_PA25 = 0x00,
	FUNC_PA25_MISO1 = 0x01,
	FUNC_PA25_TXD0 = 0x02,
	FUNC_PA25_T16N1_1 = 0x03,
} FUNC_TYPE_PA25;

/* PA27 */
typedef enum
{
	FUNC_PA27 = 0x00,
	FUNC_PA27_NSS1 = 0x01,
	FUNC_PA27_T16N_BK3 = 0x02,
	FUNC_PA27_TXD0 = 0x03,
} FUNC_TYPE_PA27;

/* PA28 */
typedef enum
{
	FUNC_PA28 = 0x00,
	FUNC_PA28_MOSI1 = 0x01,
	FUNC_PA28_NSS1 = 0x02,
	FUNC_PA28_T16N2_0 = 0x03,
} FUNC_TYPE_PA28;

/* PB0 */
typedef enum
{
	FUNC_PB0 = 0x00,
	FUNC_PB0_T32N0_0 = 0x01,
	FUNC_PB0_RXD1 = 0x02,
	FUNC_PB0_T16N3_0 = 0x03,
} FUNC_TYPE_PB0;

/* PB1 */
typedef enum
{
	FUNC_PB1 = 0x00,
	FUNC_PB1_T32N0_1 = 0x01,
	FUNC_PB1_TXD1 = 0x02,
	FUNC_PB1_T16N3_1 = 0x03,
} FUNC_TYPE_PB1;

/* PB8 */
typedef enum
{
	FUNC_PB8 = 0x00,
	FUNC_PB8_T16N_BK1 = 0x01,
	FUNC_PB8_T16N1_1 = 0x02,
	FUNC_PB8_T32N0_0 = 0x03,
} FUNC_TYPE_PB8;

/* PB9 */
typedef enum
{
	FUNC_PB9 = 0x00,
	FUNC_PB9_RXD1 = 0x01,
	FUNC_PB9_T16N1_0 = 0x02,
	FUNC_PB9_T32N0_1 = 0x03,
} FUNC_TYPE_PB9;

/* PB10 */
typedef enum
{
	FUNC_PB10 = 0x00,
} FUNC_TYPE_PB10;

/* PB11 */
typedef enum
{
	FUNC_PB11 = 0x00,
} FUNC_TYPE_PB11;

/* PB12(MRSTN) */
typedef enum
{
	FUNC_PB12 = 0x00,
	FUNC_PB12_T32N0_1 = 0x03,
} FUNC_TYPE_PB12;

/* PB13 */
typedef enum
{
	FUNC_PB13 = 0x00,
	FUNC_PB13_T16N1_0 = 0x01,
	FUNC_PB13_BUZ = 0x02,
	FUNC_PB13_T32N0_0 = 0x03,
} FUNC_TYPE_PB13;

#endif
