#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#define FILE_READ_BUF_SIZE (4096)
#define FILE_PATH_BUF_SIZE (1024)

char g_temp_file_name[FILE_PATH_BUF_SIZE] = {0U}; 
char g_temp_path[FILE_PATH_BUF_SIZE] = {0U}; 
char g_temp_path_2[FILE_PATH_BUF_SIZE] = {0U}; 
char g_run_path[FILE_PATH_BUF_SIZE] = {0U}; 
char g_lvgl_prj_out_file_path[FILE_PATH_BUF_SIZE] = {0U}; 
char g_read_file_buf[FILE_READ_BUF_SIZE] = {0U}; 
char g_handle_file_buf[FILE_READ_BUF_SIZE * 2] = {0U}; 

FILE * g_log_f = NULL;
FILE * g_out_bin_f = NULL;
FILE * g_info_c_f = NULL;

int g_out_bin_f_num = 0;
int g_out_bin_f_img_num = 0;

FILE * g_temp_out_file_img_define_f = NULL;
FILE * g_temp_out_file_img_bin_addr = NULL;
FILE * g_temp_out_file_img_info = NULL;
FILE * g_temp_out_file_font_bin_addr = NULL;

int file_read_data(FILE * file , int size ,char* buf)
{
	char ch;
	int i = 0;
 
	while (i < size)
	{
		if(EOF == (ch=fgetc(file)))
			break;
		
		buf[i] = ch;
			
		i++;
	}

	return i;
}

char* mem_find_string(char* buf,int start_index,int end_index,char* string)
{
	int string_len = strlen(string);
	char * temp_find_addr = &buf[start_index];
	int temp_start_index = start_index;
	
	if(string_len == 0)
		return NULL;
	
	while(1)
	{
		temp_start_index = temp_find_addr - buf;
		
		temp_find_addr = memchr(&buf[temp_start_index],string[0],end_index - temp_start_index);
		
		if(temp_find_addr)
		{
			if(memcmp(temp_find_addr,string,string_len) == 0)
				return temp_find_addr;
			else
			{
        		temp_find_addr++;
				continue;
			}
		}
		else
			return NULL;
	}
}

char* out_file_ascii_hex_to_char_value(char* buf,int start_index,int end_index,FILE * file)
{
	char* temp_addr;
	char* temp_addr2;
	//char* temp_addr3;
	char* temp_addr4;
	char* temp_addr5;
	char* temp_addr6;
	char temp_char_value;
	int start_addr = start_index;
	int temp_value;
	
	while(1)
	{
		if(end_index - start_addr <= 3)
		    break;
		
		temp_addr = mem_find_string(g_handle_file_buf,start_addr,end_index,"0x");
		temp_addr2 = mem_find_string(g_handle_file_buf,start_addr,end_index,"//");
		//temp_addr3 = mem_find_string(g_handle_file_buf,start_addr,end_index,"\r");
		temp_addr4 = mem_find_string(g_handle_file_buf,start_addr,end_index,"\n");
		temp_addr5 = mem_find_string(g_handle_file_buf,start_addr,end_index,"/*");
		temp_addr6 = mem_find_string(g_handle_file_buf,start_addr,end_index,"*/");
		if(temp_addr)
		{
			if(temp_addr > (g_handle_file_buf + end_index - 4))
			{
				break;
			}
			
			if(temp_addr2)
			{
				if(temp_addr4)
				{
					start_addr = temp_addr4 - g_handle_file_buf + strlen("\n");
					continue;
				}
				else
				{
					break;
				}
			}
			
			if(temp_addr5)
			{
				if(temp_addr6)
				{
					start_addr = temp_addr4 - g_handle_file_buf + strlen("*/");
					continue;
				}
				else
				{
					break;
				}
			}
			
			temp_value = 0;
			temp_addr += 2;
			
			while(1)
			{
				temp_value = temp_value << 4; 
				
				if(((*temp_addr) >= '0')&&((*temp_addr) <= '9'))
				{
					temp_value += (*temp_addr) - '0'; 
				}
				else if(((*temp_addr) >= 'a')&&((*temp_addr) <= 'f'))
				{
					temp_value += (*temp_addr) - 'a' + 10; 
				}
				else if(((*temp_addr) >= 'A')&&((*temp_addr) <= 'F'))
				{
					temp_value += (*temp_addr) - 'A' + 10; 
				}
				else
				{
					temp_value = temp_value >> 4; 
					break;
				}
				
				temp_addr++;
			}
			
			if(temp_value > 255)
			{
				fprintf(g_log_f,"[err] data format err\r\n");
				fprintf(g_log_f,"[err] data = %.20s\r\n",temp_addr-10);
				fclose(g_log_f);
				g_log_f = NULL;
				return &g_handle_file_buf[end_index];
			}
			
			temp_char_value = temp_value;
			
			fseek(file, g_out_bin_f_num, SEEK_SET);
			
			//fprintf(file,"%c",temp_char_value);
			fwrite(&temp_char_value,1,1,file),
			
			g_out_bin_f_num++;
			
			start_addr = temp_addr - g_handle_file_buf;
		}
		else
		{
			break;
		}
	}
	
	return &g_handle_file_buf[start_addr];
}

void handle_file_ui_img(char *file)
{
	FILE * f;
	int need_handle_addr = 0;
	int need_handle_addr_end = 0;
	int temp_len;
	int flag = 0;
	char* temp_addr;
	char* temp_addr2;
	
	f = fopen(file, "rb");
	if(f != NULL)
	{
		printf("handle file:%s\n",file); 
		
		fprintf(g_log_f,"[log] handle file %s ...\r\n",file);
		fprintf(g_log_f,"[log] g_out_bin_f_img_num = %d\r\n",g_out_bin_f_img_num);
		fprintf(g_log_f,"[log] g_out_bin_f_num = %d\r\n",g_out_bin_f_num);
		
		fprintf(g_info_c_f,"/*%s*/{.data_start = %d,",file,g_out_bin_f_num);
		
		fprintf(g_temp_out_file_img_define_f,"#define ");
		
					temp_addr2 = mem_find_string(file,0,strlen(file),".");
					if(temp_addr2)
					{
						temp_addr = file;
						
						while(temp_addr < temp_addr2)
						{
							fprintf(g_temp_out_file_img_define_f,"%c",*temp_addr);
							temp_addr++;
						}
					}
					
		fprintf(g_temp_out_file_img_define_f," \"#%03d.bin\"\r\n",g_out_bin_f_img_num);
		
		g_out_bin_f_img_num++;
		
		memset(g_handle_file_buf,0,2 * FILE_READ_BUF_SIZE);
		
		temp_len = file_read_data(f,FILE_READ_BUF_SIZE,g_handle_file_buf);
		
		need_handle_addr = 0;
		need_handle_addr_end = temp_len - 1;
		
		while(temp_len != 0)
		{
			memcpy(g_handle_file_buf,&g_handle_file_buf[need_handle_addr],need_handle_addr_end - need_handle_addr + 1);
			temp_len = file_read_data(f,FILE_READ_BUF_SIZE,&g_handle_file_buf[need_handle_addr_end - need_handle_addr + 1]);
			
			need_handle_addr_end = need_handle_addr_end - need_handle_addr + temp_len;
			need_handle_addr = 0;
		
			memset(&g_handle_file_buf[need_handle_addr_end + 1],0,2 * FILE_READ_BUF_SIZE - need_handle_addr_end - 1);
		
			/*һ"{"*/
			if(flag == 0)
			{
				temp_addr = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,"{");
				if(temp_addr)
				{
					flag = 1;
					need_handle_addr = temp_addr - g_handle_file_buf;
					need_handle_addr++;
				}
			}
			
			/*ʼת,"}"ת*/
			if(flag == 1)
			{
				temp_addr = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,"}");
				if(temp_addr)
				{
					out_file_ascii_hex_to_char_value(g_handle_file_buf,need_handle_addr,temp_addr - g_handle_file_buf,g_out_bin_f);
					
					flag = 2;
					need_handle_addr = temp_addr - g_handle_file_buf;
					need_handle_addr++;
					
				}
				else
				{
					temp_addr = out_file_ascii_hex_to_char_value(g_handle_file_buf,need_handle_addr,need_handle_addr_end,g_out_bin_f);
					
                	need_handle_addr = temp_addr - g_handle_file_buf;
				}

			}
			
			/*"lv_img_dsc_t"ͼƬλò*/
			if(flag == 2)
			{
				temp_addr = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,"lv_img_dsc_t");
				if(temp_addr)
				{
					flag = 3;
					need_handle_addr = temp_addr - g_handle_file_buf;
					need_handle_addr++;
				}
			}
			
			/*".header." ","ͼƬϢ*/
			if(flag == 3)
			{
				while(1)
				{
					temp_addr = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,".header.");
					if(temp_addr)
					{
						temp_addr2 = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,",");
						if(temp_addr2)
						{
							while(temp_addr <= temp_addr2)
							{
								fprintf(g_info_c_f,"%c",*temp_addr);
								temp_addr++;
							}
							//fprintf(g_info_c_f,"\r\n");
							need_handle_addr = temp_addr2 - g_handle_file_buf;
							need_handle_addr++;
						} 
					}
					
					if((temp_addr == NULL)||(temp_addr2 == NULL))
					{
						break;
					}
				}
			}
		} 
		
		fprintf(g_info_c_f,"} ,\r\n");
		
		fclose(f);
	}
	else
	{
		fprintf(g_log_f,"[err] open file %s err\r\n",file);
	}
}

void handle_file_ui_font(char *file)
{
	FILE * f;
	FILE * new_f;
	
	memcpy(g_temp_file_name,"es_",strlen("es_"));
	memcpy(g_temp_file_name + strlen("es_"),file,strlen(file));
	
	f = fopen(file, "rb");
	if(f != NULL)
	{
		new_f = fopen(g_temp_file_name, "wb");
		if(new_f != NULL)
		{
			
			
			
			fclose(new_f);
		}
		
		fclose(f);
	}
	else
	{
		fprintf(g_log_f,"[err] open file %s err\r\n",file);
	}
}

void handle_file_ui_h(char *file)
{
	char* string_i = NULL;
	int temp_ui_file_out_num = 0;
	FILE * f = NULL;
	FILE * new_f = NULL;
	int need_handle_addr = 0;
	int need_handle_addr_end = 0;
	int temp_len;
	char* temp_addr;
	char* temp_addr2;
	int out_img_info_flag = 1; 
	char ch;
	
	f = fopen(file, "rb");
	if(f != NULL)
	{
		printf("handle file:%s\n",file); 
		
		new_f = fopen("es_temp_new_ui.h","wb");
		if(new_f != NULL)
		{
			
			memset(g_handle_file_buf,0,2 * FILE_READ_BUF_SIZE);
			
			temp_len = file_read_data(f,FILE_READ_BUF_SIZE,g_handle_file_buf);
			
			need_handle_addr = 0;
			need_handle_addr_end = temp_len - 1;
			
			while(temp_len != 0)
			{
				memcpy(g_handle_file_buf,&g_handle_file_buf[need_handle_addr],need_handle_addr_end - need_handle_addr + 1);
				temp_len = file_read_data(f,FILE_READ_BUF_SIZE,&g_handle_file_buf[need_handle_addr_end - need_handle_addr + 1]);
				
				need_handle_addr_end = need_handle_addr_end - need_handle_addr + temp_len;
				need_handle_addr = 0;
			
				memset(&g_handle_file_buf[need_handle_addr_end + 1],0,2 * FILE_READ_BUF_SIZE - need_handle_addr_end - 1);
			
				/*滻lvgl/lvgl.hΪlvgl.h*/
				if(1)
				{
					temp_addr = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,"#include \"lvgl/lvgl.h\"");
					if(temp_addr)
					{
						for(string_i = &g_handle_file_buf[need_handle_addr];string_i < temp_addr;string_i++)
						{
							fseek(new_f, temp_ui_file_out_num, SEEK_SET);
								
							fwrite(string_i,1,1,new_f),
								
							temp_ui_file_out_num ++;
						}
						
						need_handle_addr = temp_addr - g_handle_file_buf + strlen("#include \"lvgl/lvgl.h\"");
						
						fseek(new_f, temp_ui_file_out_num, SEEK_SET);
						fprintf(new_f,"#include \"lvgl.h\"");
						temp_ui_file_out_num += strlen("#include \"lvgl.h\"");
					}
				}
				
				/*ͼƬϢ*/
				if(1)
				{
					while(1)
					{
						temp_addr = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,"LV_IMG_DECLARE(");
						temp_addr2 = mem_find_string(g_handle_file_buf,need_handle_addr,need_handle_addr_end,");");
						
						if((temp_addr)&&(temp_addr2))
						{
							if(temp_addr >= temp_addr2)
							{
								for(string_i = &g_handle_file_buf[need_handle_addr];string_i < temp_addr;string_i++)
								{
									fseek(new_f, temp_ui_file_out_num, SEEK_SET);
													
									fwrite(string_i,1,1,new_f),
													
									temp_ui_file_out_num++;
								}
								
								need_handle_addr = temp_addr - g_handle_file_buf;
								continue;
							}
							else
							{
								need_handle_addr = temp_addr2 - g_handle_file_buf + strlen(");");
							}
							
							if(out_img_info_flag)
							{
								out_img_info_flag = 0;
								
    							if(g_temp_out_file_img_define_f)
    							{
    								while (1)
									{
										if(EOF == (ch=fgetc(g_temp_out_file_img_define_f)))
											break;
										
										fseek(new_f, temp_ui_file_out_num, SEEK_SET);
										
										fwrite(&ch,1,1,new_f),
										
										temp_ui_file_out_num++;
									}
								}
							}
						}
						else
						{
							break;
						}
					}
				}
			} 
			
			if(need_handle_addr <= need_handle_addr_end)
			{
				fseek(new_f, temp_ui_file_out_num, SEEK_SET);
									
				fwrite(&g_handle_file_buf[need_handle_addr],1,need_handle_addr_end - need_handle_addr + 1,new_f),
									
				temp_ui_file_out_num += need_handle_addr_end - need_handle_addr + 1;
			}
			
			fclose(new_f);
		}
		
		fclose(f);
	}
	else
	{
		fprintf(g_log_f,"[err] open file %s err\r\n",file);
	}
}

void handle_dir_ui(char *dir,int depth,int t_flag)
{
	DIR *dp;
	struct dirent *entry;
	struct stat statbuf;
	
	dp = opendir(dir);
	if (NULL == dp)
	{
		fprintf(g_log_f,"[err]opendir %s failed\r\n", dir);
		return;
	}
	chdir(dir);
	while((entry = readdir(dp)) != NULL)
	{
		stat(entry->d_name, &statbuf);
		if(S_ISDIR(statbuf.st_mode))
		{
			if ((strcmp(entry->d_name, "..") == 0) || (strcmp(entry->d_name, ".") == 0))
			{
				continue;
			}
			fprintf(g_log_f,"[log]%*sdir:%s\n", depth, "", entry->d_name);
			handle_dir_ui(entry->d_name, depth+4,t_flag);
		}
		else
		{
			fprintf(g_log_f,"[log]%*sfile:%s\n", depth, "", entry->d_name);
			
			if(t_flag == 1)
			{
				if(memcmp(entry->d_name, "ui_img_",strlen("ui_img_")) == 0)
				{
					handle_file_ui_img(entry->d_name);
				}
				
				if(memcmp(entry->d_name, "ui_font_",strlen("ui_font_")) == 0)
				{
					handle_file_ui_font(entry->d_name);
				}
			}
			
			if(t_flag == 2)
			{
				if(memcmp(entry->d_name, "ui.h",strlen("ui.h")) == 0)
				{
					handle_file_ui_h(entry->d_name);
				} 
			}
		}
	}
	chdir("..");
	closedir(dp);
}

int main(void)
{
	int i;
	char * path_find_char_addr;
	
    system("title test");
	
	printf("start\n");
	
    g_log_f = fopen("tst_log.txt", "wb");
    g_out_bin_f = fopen("spi_flash_data.bin", "wb");
    g_info_c_f = fopen("spi_flash_data_info.c", "wb");
    g_temp_out_file_img_define_f = fopen("temp_file_img_path_def.c","wb");
    
    if (g_log_f == NULL)
   	{
   		return 0;
	}
	
    if ((g_out_bin_f == NULL)||(g_info_c_f == NULL)||(g_temp_out_file_img_define_f == NULL))
   	{
   		fprintf(g_log_f,"[err]open file err\r\n");
  		fclose(g_log_f);
   		return 0;
	}
	
    _getcwd(g_run_path,FILE_PATH_BUF_SIZE);
    _getcwd(g_temp_path,FILE_PATH_BUF_SIZE);
    fprintf(g_log_f,"[log]code run path:%s\r\n",g_temp_path);
    
	fprintf(g_info_c_f,"#include \"spi_flash.h\"\r\n");
	fprintf(g_info_c_f,"const es_lv_ext_img_info_t g_es_ext_store_pictrue_info[] =\n{\n");
	
	for(i = 0;i < 2;i++)
	{
		path_find_char_addr = strrchr(g_temp_path,'\\');
		
		if(path_find_char_addr)
			*path_find_char_addr = '\0';
	}
	
	strcpy(path_find_char_addr,"\\GUI_prj\\SquareLine_prj3\\export_files");

	memcpy(g_lvgl_prj_out_file_path,g_temp_path,FILE_PATH_BUF_SIZE);

	handle_dir_ui(g_temp_path,0,1);/*ͼƬ*/

	fprintf(g_info_c_f,"};");
	
   	fprintf(g_log_f,"[log]end\r\n");
	fprintf(g_log_f,"[log]end g_out_bin_f_num = %d,",g_out_bin_f_num);
   	
	fprintf(g_temp_out_file_img_define_f,"#define ES_EXTERN_IMG_NUM %d\r\n",g_out_bin_f_img_num);
		
    fclose(g_temp_out_file_img_define_f);
   	
	chdir(g_run_path);
   	
    g_temp_out_file_img_define_f = fopen("temp_file_img_path_def.c","rb");
    
	handle_dir_ui(g_temp_path,0,2);/*ui.h*/
    
    fclose(g_temp_out_file_img_define_f);
   
  	fclose(g_log_f);
    fclose(g_out_bin_f);
    fclose(g_info_c_f);
    
	chdir(g_lvgl_prj_out_file_path);
   	
    remove("ui.h");
    rename("es_temp_new_ui.h","ui.h");
    
	chdir(g_run_path);
   	
   	remove("Src\\spi_flash_data_info.c");
   	
   	rename("spi_flash_data_info.c","Src\\spi_flash_data_info.c");
   	
   	remove("spi_flash_data_info.c"); 
   	remove("temp_file_img_path_def.c"); 
   	remove("tst_log.txt"); 
    
    printf("end\n");
    
    system("pause");
    
   	return 0;
}
