/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    5 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 Jan. 2023     Biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */


/**
  * @brief  UART IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) EUART1_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_uart_mask_it_linbk(LIN_NODE))
    {
        /* Clear lin break interrupt flag */
        md_uart_clear_flag_linbk(LIN_NODE);
        /* clear interrupt flag of rx byte format error */
        md_uart_clear_flag_rxberr(LIN_NODE);

        /* Change frame stage to sync_stage */
        lin_break_seg_proc(&g_node1);
    }

    if (md_uart_mask_it_rfnempty(LIN_NODE))
    {
        md_uart_clear_flag_rfnempty(LIN_NODE);

        while (md_uart_is_active_flag_rfnempty(LIN_NODE))
        {
            lin_recv_data_proc(&g_node1, md_uart_recv_data8(LIN_NODE));
        }
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @brief  EXTI handler
  * @retval None
  */
void __attribute__((interrupt)) EXTI0_3_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_gpio_is_enabled_external_interrupt(EXTI_PIN_1) && md_gpio_get_flag(EXTI_PIN_1))
    {
        md_gpio_clear_flag(EXTI_PIN_1);                   /* clear exit interrupt flag */

        g_master_write = 1;
    }

    if (md_gpio_is_enabled_external_interrupt(EXTI_PIN_2) && md_gpio_get_flag(EXTI_PIN_2))
    {
        md_gpio_clear_flag(EXTI_PIN_2);                   /* clear exit interrupt flag */

        g_master_read = 1;
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
