/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    3 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          3 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* AD16C4T Handler */
/**
  * @}
  */
void __attribute__((interrupt)) AD16C4T_UP_TRIG_COM_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_timer_get_update_valid_interrupt_flag_uei(AD16C4T) == 1U)
        md_timer_clear_update_interrupt_flag_ueic(AD16C4T);

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

void __attribute__((interrupt)) AD16C4T_CC_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_timer_get_cc1_valid_interrupt_flag_ch1cci(AD16C4T))
        md_timer_clear_cc1_interrupt_flag_ch1ccic(AD16C4T);

    if (md_timer_get_cc2_valid_interrupt_flag_ch2cci(AD16C4T))
        md_timer_clear_cc2_interrupt_flag_ch2ccic(AD16C4T);

    if (md_timer_get_cc3_valid_interrupt_flag_ch3cci(AD16C4T))
        md_timer_clear_cc3_interrupt_flag_ch3ccic(AD16C4T);

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
