/**********************************************************************************
 *
 * @file    wm8978.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef __WM8978_H
#define __WM8978_H

/* Includes ---------------------------------------------------------------- */

#include <md_conf.h>
#include <md_i2c.h>
/* Exported Types ---------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

#define WM8978_ADDR 0X1A

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */
void IIC_Start(void);                                                   /*Send the IIC start signal*/
void IIC_Stop(void);                                                /*Send the IIC stop signal*/
void IIC_Send_Byte(uint8_t txd);                            /*IIC sends a byte*/
uint8_t IIC_Read_Byte(unsigned char ack);           /*IIC read a byte*/
uint8_t IIC_Wait_Ack(void);                                     /*IIC wait for an ACK signal*/
void IIC_Ack(void);                                                     /*IIC an ACK signal*/
void IIC_NAck(void);                                                    /*IIC is not an ACK signal*/
uint8_t IIC_Write_One_Byte(uint8_t DevAddr, uint8_t RegAddr, uint8_t Data);
uint8_t IIC_Read_One_Byte(uint8_t DevAddr, uint8_t RegAddr);
void delay_us(uint16_t us);

uint8_t WM8978_Write_Reg(uint8_t reg, uint16_t val);
uint16_t WM8978_Read_Reg(uint8_t reg);
uint8_t WM8978_Init(void *i2c_dev);
void WM8978_ADDA_Cfg(uint8_t dacen, uint8_t adcen);
void WM8978_Output_Cfg(uint8_t dacen, uint8_t bpsen);
void WM8978_HPvol_Set(uint8_t voll, uint8_t volr);
void WM8978_SPKvol_Set(uint8_t volx);
void WM8978_I2S_Cfg(uint8_t fmt, uint8_t len);
void WM8978_Input_Cfg(uint8_t micen, uint8_t lineinen, uint8_t auxen);
void WM8978_MIC_Gain(uint8_t gain);
void WM8978_LINEIN_Gain(uint8_t gain);
void WM8978_AUX_Gain(uint8_t gain);

#endif /* __WM8978_H */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
