/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    9 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          9 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ------------------------------------------------------------------ */

#include "md_utils.h"
#include "md_spi.h"
#include "md_gpio.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define FLASH_CS_SET()  (md_gpio_write_pin(GPIOA, MD_GPIO_PIN_4, 1))
#define FLASH_CS_CLR()  (md_gpio_write_pin(GPIOA, MD_GPIO_PIN_4, 0))

#define FLASH_WRITE_ENABLE  0x06
#define FLASH_ERASE         0x20
#define FLASH_PROGRAM       0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

md_status_t flash_sector_erase(uint32_t addr);
md_status_t flash_write(uint32_t addr, char *buf, uint16_t size);
md_status_t flash_read(uint32_t addr, char *buf, uint16_t size);
md_status_t flash_wait_unbusy(void);
uint32_t flash_read_id(void);
void mcu_spi_init(void);

#endif    /*__FLASH_H__*/


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
