/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    9 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          9 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Variables --------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Public Variables ---------------------------------------------------------- */
md_spi_init_t g_h_spi;

uint8_t g_recv_buf[20] = {0U};
uint8_t g_send_buf[20] = {0U};
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_recv_len = sizeof(g_recv_buf);

md_dma_config_t g_dma_tx_config, g_dma_rx_config;

/* Private Function ---------------------------------------------------------- */

/*Host mode communication pins initialization function*/
void spi_pin_init(void)
{
    md_gpio_init_t gpio_init;

    /* Host SCK pin initialization, configuration for the input mode */
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_SCK_PORT, SPI_SCK_PIN, &gpio_init);

    /*Host MISO pins initialization, configuration for the output mode*/
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_MISO_PORT, SPI_MISO_PIN, &gpio_init);

    /*Host MOSI pin initialization, configuration for the input mode*/
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_MOSI_PORT, SPI_MOSI_PIN, &gpio_init);

    /*Host NSS pin initialization, configuration for the input mode*/
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_NSS_PORT, SPI_NSS_PIN, &gpio_init);
    md_gpio_set_pin_high(SPI_NSS_PORT, SPI_NSS_PIN);
}

/**
  * @brief  dma_start_tx init.
  * @param  None
  * @retval None
  */
void dma_send_tx(void)
{
    md_dma_config_t dma_tx_config;

    md_dma_enable_it_tc(MD_DMA_CH_0);

    memset(&g_dma_tx_config, 0x0, sizeof(md_dma_config_t));
    dma_tx_config.src            = (void *)g_recv_buf;
    dma_tx_config.dst            = (void *)&SPI0->DATA;
    dma_tx_config.size           = g_send_len;
    dma_tx_config.src_data_width = MD_DMA_DATA_SIZE_BYTE;
    dma_tx_config.dst_data_width = MD_DMA_DATA_SIZE_BYTE;
    dma_tx_config.src_inc        = ENABLE;
    dma_tx_config.dst_inc        = DISABLE;
    dma_tx_config.R_power        = MD_DMA_R_POWER_1;
    dma_tx_config.priority       = MD_DMA_LOW_PRIORITY;
    dma_tx_config.mem_to_mem     = DISABLE;
    dma_tx_config.circle_mode    = ENABLE;
    dma_tx_config.msel           = MD_DMA_MSEL_SPI0;
    dma_tx_config.msigsel        = MD_DMA_MSIGSEL_SPI_TXEMPTY;
    md_dma_init(MD_DMA_CH_0, &dma_tx_config);
}
/**
  * @brief  dma_start_rx init.
  * @param  None
  * @retval None
  */
void dma_recv_rx(void)
{
    md_dma_enable_it_tc(MD_DMA_CH_1);

    memset(&g_dma_rx_config, 0x0, sizeof(md_dma_config_t));
    g_dma_rx_config.src            = (void *)&SPI0->DATA;
    g_dma_rx_config.dst            = (void *)g_recv_buf;
    g_dma_rx_config.size           = g_recv_len;
    g_dma_rx_config.src_data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_rx_config.dst_data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_rx_config.src_inc        = DISABLE;
    g_dma_rx_config.dst_inc        = ENABLE;
    g_dma_rx_config.R_power        = MD_DMA_R_POWER_1;
    g_dma_rx_config.priority       = MD_DMA_LOW_PRIORITY;
    g_dma_rx_config.mem_to_mem     = DISABLE;
    g_dma_rx_config.circle_mode    = ENABLE;
    g_dma_rx_config.msel           = MD_DMA_MSEL_SPI0;
    g_dma_rx_config.msigsel        = MD_DMA_MSIGSEL_SPI_RNR;
    md_dma_init(MD_DMA_CH_1, &g_dma_rx_config);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC48M, 48000000);
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    spi_pin_init();

    md_spi_struct_init(&g_h_spi);
    g_h_spi.SPIx      = SPI0;
    g_h_spi.mode      = MD_SPI_MODE_SLAVER;
    g_h_spi.dir       = MD_SPI_DIRECTION_2LINES;
    g_h_spi.data_size = MD_SPI_DATA_SIZE_8;
    g_h_spi.baud      = MD_SPI_BAUD_256;
    g_h_spi.phase     = MD_SPI_CPHA_SECOND;
    g_h_spi.polarity  = MD_SPI_CPOL_HIGH;
    g_h_spi.first_bit = MD_SPI_FIRSTBIT_MSB;
    g_h_spi.ss_en     = DISABLE;
    g_h_spi.crc_calc  = DISABLE;
    g_h_spi.crc_poly  = 0;
    md_spi_init(&g_h_spi);

    md_mcu_irq_config(DMA_IRQn, 0, ENABLE);
    __enable_irq();

    dma_send_tx();
    dma_recv_rx();

    md_dma_enable_channel(MD_DMA_CH_0);
    md_spi_enable_txdma(SPI0);
    md_dma_enable_channel(MD_DMA_CH_1);
    md_spi_enable_rxdma(SPI0);

    while (1);
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
