/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    4 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          4 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Variables --------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Public Variables ---------------------------------------------------------- */
md_spi_init_t g_spi_config;

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of spi module.
  * @retval None
  */
void spi_pin_init(void)
{
    md_gpio_init_t gpio_init;

    /*Host SCK pin initialization, configuration for the input mode*/
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_SCK_PORT, SPI_SCK_PIN, &gpio_init);

    /*Host MISO pins initialization, configuration for the output mode*/
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_MISO_PORT, SPI_MISO_PIN, &gpio_init);

    /*Host MOSI pin initialization, configuration for the input mode*/
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_MOSI_PORT, SPI_MOSI_PIN, &gpio_init);

    /*Host NSS pin initialization, configuration for the input mode*/
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_PUSH_UP;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_2;
    md_gpio_init(SPI_NSS_PORT, SPI_NSS_PIN, &gpio_init);
    md_gpio_set_pin_high(SPI_NSS_PORT, SPI_NSS_PIN);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC4M, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    /* SPI interrupt initialization: set interrupt */
    md_mcu_irq_config(SPI0_I2S0_IRQn, 0, ENABLE);
    __enable_irq();

    spi_pin_init();

    md_spi_struct_init(&g_spi_config);
    g_spi_config.SPIx      = SPI0;
    g_spi_config.mode      = MD_SPI_MODE_SLAVER;
    g_spi_config.dir       = MD_SPI_DIRECTION_2LINES;
    g_spi_config.data_size = MD_SPI_DATA_SIZE_8;
    g_spi_config.baud      = MD_SPI_BAUD_256;
    g_spi_config.phase     = MD_SPI_CPHA_SECOND;
    g_spi_config.polarity  = MD_SPI_CPOL_HIGH;
    g_spi_config.first_bit = MD_SPI_FIRSTBIT_MSB;
    g_spi_config.ss_en     = DISABLE;
    g_spi_config.crc_calc  = DISABLE;
    g_spi_config.crc_poly  = 0;
    md_spi_init(&g_spi_config);

    md_spi_enable_it_rxne(SPI0);
    md_spi_enable_it_txe(SPI0);

    while (1);
}

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
