/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    4 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          4 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Private Variables --------------------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */
/* Public Variables ---------------------------------------------------------- */
uint8_t g_send_buf[20] = {0U};
uint8_t g_recv_buf[20] = {0U};
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_send_ind = 0U;
uint8_t g_recv_ind = 0U;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  CLINT irq handler
  * @retval None
  */
void __attribute__((interrupt)) CLINT_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    csi_coret_clr(md_cmu_get_clock() / 1000, CLINT_IRQn);
    md_inc_tick();

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @brief  SPI irq handler
  * @retval None
  */
void __attribute__((interrupt)) SPI0_I2S0_Handler(void)
{
    uint16_t cnt;

    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    /* if tx fifo is empty, send data */
    if (md_spi_mask_it_txe(SPI0))
    {
        md_spi_set_data_reg(SPI0, g_recv_buf[g_send_ind++]);
        md_spi_clear_flag_txe(SPI0);

        if (g_send_ind >= g_send_len)
        {
            cnt = 4000;

            while (!md_spi_is_active_flag_txe(SPI0) && (--cnt));

            cnt = 4000;

            while (md_spi_is_active_flag_busy(SPI0) && (--cnt));

            g_send_ind = 0;
        }
    }

    /* if rx data is not empty, receive data */
    if (md_spi_mask_it_rxne(SPI0))
    {
        g_recv_buf[g_recv_ind++] = md_spi_get_data_reg_value(SPI0);
        md_spi_clear_flag_rxne(SPI0);

        if (g_recv_ind >= g_recv_len)
            g_recv_ind = 0;
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
