/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    6 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "bat.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate lvd.
  * @retval None
  */
void init_lvd_powerdown(void)
{
    MD_SYSCFG_UNLOCK();
    md_pmu_lvd_config(MD_PMU_LVD_VOL_SEL_3_6, MD_PMU_LVD_TRIGGER_HIGH_LEVEL, ENABLE);
    md_pmu_set_lvd_it_flag(); /* clear LVD interrupt flag */
    MD_SYSCFG_LOCK();

    csi_vic_clear_pending_irq(LVD_IRQn);

    return;
}
/**
  * @brief  Pins initialization function
  * @retval None.
  */
void init_pin(void)
{
    md_gpio_init_t gpio_init;

    /* Initialize GPIO as input */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(PMU_EXTI_PORT, PMU_EXTI_PIN, &gpio_init);

    /* Initialize external interrupt */
    md_gpio_interrupt_filter_time_set(10U);        /* set filter times: ((10 + 1) * 2)CLOCK */
    md_gpio_interrupt_filter_enable(PMU_EXTI_PIN); /* enable exit filter */

    md_gpio_set_interrupt_port(PMU_EXTI_PORT, PMU_EXTI_PIN);      /* set exit interrupt port */
    md_gpio_enable_riging_edge_trigger(PMU_EXTI_PIN); /* enable riging edge trigger */
    md_gpio_enable_external_interrupt(PMU_EXTI_PIN);  /* enable exti2 */
    md_mcu_irq_config(EXTI0_3_IRQn, 0, ENABLE);       /* enable NVIC EXTI0_3_IRQn */

    /* Initialize LED port */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    gpio_init.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt  = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.func = MD_GPIO_FUNC_1;

    md_gpio_init(LED_PORT, LED_PIN, &gpio_init);
    md_gpio_set_pin_high(LED_PORT, LED_PIN);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    __enable_irq();

    init_lvd_powerdown();

    md_delay_1ms(10);

    if (md_pmu_is_active_flag_lvd_it())    /* power is lower */
        bat_proc();

    init_pin();

    md_mcu_irq_config(LVD_IRQn, 0, ENABLE);

    while (1)
    {
        md_gpio_set_pin_low(LED_PORT, LED_PIN);
        md_delay_1ms(500);
        md_gpio_set_pin_high(LED_PORT, LED_PIN);
        md_delay_1ms(500);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
