/**********************************************************************************
 *
 * @file    bat.c
 * @brief   bat file for DEMO
 *
 * @date    6 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "bat.h"
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_PMU
  * @{
  */

/* Private Macros ------------------------------------------------------------ */
/* Only one macro can be opened at a time */
/* #define LP_MODE_SLEEP */
#define LP_MODE_STOP

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate lvd.
  * @retval None
  */
void init_lvd_powerup(void)
{
    MD_SYSCFG_UNLOCK();
    md_pmu_lvd_config(MD_PMU_LVD_VOL_SEL_3_6, MD_PMU_LVD_TRIGGER_LOW_LEVEL, ENABLE);
    md_pmu_enable_lvd_it();
    md_pmu_set_lvd_it_flag(); /* clear LVD interrupt flag */
    MD_SYSCFG_LOCK();

    csi_vic_clear_pending_irq(LVD_IRQn);

    md_mcu_irq_config(LVD_IRQn, 0, ENABLE);

    return;
}

/**
  * @brief  Test battery function
  * @retval Status.
  */
void bat_proc(void)
{
    init_pin();
    init_lvd_powerup();

    while (1)
    {
#ifdef LP_MODE_SLEEP
        /* Prevent CLINT interrupt wake up sleep */
        csi_vic_disable_sirq(CLINT_IRQn);

        md_pmu_sleep_enter();

        csi_vic_enable_sirq(CLINT_IRQn);
#endif /* LP_MODE_SLEEP */
#ifdef LP_MODE_STOP
        md_pmu_stop_enter();
#endif /* LP_MODE_STOP */

        md_gpio_set_pin_low(LED_PORT, LED_PIN);

        md_delay_1ms(500);

        md_gpio_set_pin_high(LED_PORT, LED_PIN);
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
