/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    5 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          5 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  I2C irq handler
  * @retval None
  */
void __attribute__((interrupt)) I2C0_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    /* if tx data is empty, send data */
    if (md_i2c_mask_it_txe(I2CX))
    {
        md_i2c_set_tx_reg_data(I2CX, g_send_buf[g_send_inc]);
        md_i2c_clear_flag_txe(I2CX);

        g_send_inc++;

        if (g_send_inc >= g_send_len)
		{
            md_i2c_disable_it_txe(I2CX);
            g_send_inc = 0;
		}
    }

    /* if rx data is not empty, transmit data */
    if (md_i2c_mask_it_rxne(I2CX))
    {
        g_recv_buf[g_recv_inc] = md_i2c_get_rx_reg_data(I2CX);
		md_i2c_clear_flag_rxne(I2CX);

        g_recv_inc++;

        if (g_recv_inc >= g_recv_len)
        {
            g_recv_inc = 0;
            memcpy(g_send_buf, g_recv_buf, g_recv_len);
        }
    }

    /* if a matching address is received */
    if (md_i2c_mask_it_addr(I2CX))
    {
        md_i2c_clear_flag_addr(I2CX);

        if (md_i2c_is_active_flag_read(I2CX))
            /* Enable TXE interrupt */
            md_i2c_enable_it_txe(I2CX);
        else
            /* Enable RXNE interrupt */
            md_i2c_enable_it_rxne(I2CX);
    }

    /* if a stop bit is received */
    if (md_i2c_mask_it_stop(I2CX))
    {
        md_i2c_clear_flag_stop(I2CX);

        /* Enable RXNE interrupt */
        md_i2c_disable_it_rxne(I2CX);

        g_send_inc = 0;
        g_recv_inc = 0;
    }

    if (md_i2c_mask_it_nack(I2CX))
    {
        md_i2c_clear_flag_nack(I2CX);

        md_i2c_disable_it_txe(I2CX);

        g_send_inc = 0;
        g_recv_inc = 0;
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
