/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    6 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uint8_t g_recv_buf[20];
uint8_t g_recv_len = sizeof(g_recv_buf);
uint8_t g_recv_inc = 0U;
uint8_t g_send_buf[20];
uint8_t g_send_len = sizeof(g_send_buf);
uint8_t g_send_inc = 0U;
uint8_t g_complete = 1U;
uint8_t g_error_flag = 0U;

md_dma_config_t g_dma_rx_config, g_dma_tx_config;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void i2c_pin_init(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize scl pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C_SCL_PORT, I2C_SCL_PIN, &gpio_init);

    /* Initialize sda pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_5;
    md_gpio_init(I2C_SDA_PORT, I2C_SDA_PIN, &gpio_init);
}

/**
  * @brief  dma_start_tx init.
  * @param  None
  * @retval None
  */
void dma_send_tx(void)
{
    md_dma_enable_it_tc(MD_DMA_CH_0);

    memset(&g_dma_tx_config, 0x0, sizeof(md_dma_config_t));
    g_dma_tx_config.src            = (void *)g_send_buf;
    g_dma_tx_config.dst            = (void *)&I2CX->TXDATA;
    g_dma_tx_config.size           = g_send_len;
    g_dma_tx_config.src_data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_tx_config.dst_data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_tx_config.src_inc        = ENABLE;
    g_dma_tx_config.dst_inc        = DISABLE;
    g_dma_tx_config.R_power        = MD_DMA_R_POWER_1;
    g_dma_tx_config.priority       = MD_DMA_LOW_PRIORITY;
    g_dma_tx_config.mem_to_mem     = DISABLE;
    g_dma_tx_config.circle_mode    = DISABLE;
    g_dma_tx_config.msel           = MD_DMA_MSEL_I2C0;
    g_dma_tx_config.msigsel        = MD_DMA_MSIGSEL_I2C_TXEMPTY;
    md_dma_init(MD_DMA_CH_0, &g_dma_tx_config);
}
/**
  * @brief  dma_start_rx init.
  * @param  None
  * @retval None
  */
void dma_recv_rx(void)
{
    md_dma_enable_it_tc(MD_DMA_CH_1);

    memset(&g_dma_rx_config, 0x0, sizeof(md_dma_config_t));
    g_dma_rx_config.src            = (void *)&I2CX->RXDATA;
    g_dma_rx_config.dst            = (void *)g_recv_buf;
    g_dma_rx_config.size           = g_recv_len;
    g_dma_rx_config.src_data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_rx_config.dst_data_width = MD_DMA_DATA_SIZE_BYTE;
    g_dma_rx_config.src_inc        = DISABLE;
    g_dma_rx_config.dst_inc        = ENABLE;
    g_dma_rx_config.R_power        = MD_DMA_R_POWER_1;
    g_dma_rx_config.priority       = MD_DMA_LOW_PRIORITY;
    g_dma_rx_config.mem_to_mem     = DISABLE;
    g_dma_rx_config.circle_mode    = DISABLE;
    g_dma_rx_config.msel           = MD_DMA_MSEL_I2C0;
    g_dma_rx_config.msigsel        = MD_DMA_MSIGSEL_I2C_RNR;
    md_dma_init(MD_DMA_CH_1, &g_dma_rx_config);
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main(void)
{
    uint16_t cnt;
    md_i2c_init_t md_i2c;

    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC48M, 48000000);
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    i2c_pin_init();

    md_i2c_struct_init(&md_i2c);
    /* Initialize I2C */
    md_i2c.module       = MD_I2C_MODULE_MASTER;
    md_i2c.addr_mode    = MD_I2C_ADDR_7BIT;
    md_i2c.clk_speed    = MD_I2C_STANDARD_MODE_MAX_CLK;
    md_i2c.dual_addr    = MD_I2C_DUALADDR_DISABLE;
    md_i2c.general_call = MD_I2C_GENERALCALL_DISABLE;
    md_i2c.no_stretch   = MD_I2C_NOSTRETCH_DISABLE;
    md_i2c.own_addr1    = 0x2D << 1;
    md_i2c_init(I2CX, &md_i2c);

    /* enable automatic end and automatically send stop bit */
    md_i2c_enable_auto_end(I2CX);
    /* set slave address */
    md_i2c_set_slave_addr(I2CX, SLAVE_ADDR << 1);
    /* set transmission length */
    md_i2c_set_transmit_length(I2CX, 20);
    /* Enable NACK interrupt */
    md_i2c_enable_it_nack(I2CX);

    md_mcu_irq_config(I2C0_IRQn, 1, ENABLE);
    md_mcu_irq_config(DMA_IRQn, 0, ENABLE);
    __enable_irq();

    dma_recv_rx();
    dma_send_tx();

    while (1)
    {
        /* receive */
        g_complete = 0;
        /* Enable DMA channel */
        md_dma_enable_channel(MD_DMA_CH_1);
        /* select master read mode */
        md_i2c_enable_master_read(I2CX);
        /* enable RX DMA */
        md_i2c_enable_dma_receive(I2CX);
        /* produce start signal */
        md_i2c_set_start(I2CX);

        cnt = 40000;

        while (!g_complete && (--cnt));

        cnt = 40000;

        while (md_i2c_is_active_busy(I2CX) && (--cnt));

        memcpy(g_send_buf, g_recv_buf, g_recv_len);

        /* send */
        g_complete = 0;
        /* Enable DMA channel */
        md_dma_enable_channel(MD_DMA_CH_0);
        /* select master write mode */
        md_i2c_enable_master_write(I2CX);
        /* enable TX DMA */
        md_i2c_enable_dma_transmit(I2CX);
        /* produce start signal */
        md_i2c_set_start(I2CX);

        cnt = 40000;

        while (!g_complete && (--cnt));

        cnt = 40000;

        while (md_i2c_is_active_busy(I2CX) && (--cnt));

        md_delay_1ms(2000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
