/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    23 July 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 July 2024    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Private Variables --------------------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/****************** Peripheral Interrupt HANDLER ************************/

/**
  * @} Examples_SPI
  */

/**
  * @brief  DMA IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) DMA_Handler(void)
{
	uint16_t cnt;

    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_dma_is_active_flag_tc(MD_DMA_CH_0))
    {
		md_dma_clear_flag_tc(MD_DMA_CH_0);

        cnt = 40000U;
        while(md_spi_is_active_flag_busy(SPI1) && --cnt);

        md_dma_disable_channel(MD_DMA_CH_0);
        md_spi_disable_rxdma(SPI0);

        g_complete = 1;
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
