/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    24 May 2024
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          24 May 2024     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Variables --------------------------------------------------------- */
/* Length must be less than one page (256 bytes) */
static char s_flash_txbuf[64] = "The data are read from Flash by SPI0.\r\n";

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Macros ------------------------------------------------------------ */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_SPI
  * @{
  */
/* Public Variables ---------------------------------------------------------- */
uint32_t g_flash_data_size = 0U;

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    md_status_t status;

    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC4M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    md_mcu_irq_config(DMA_IRQn, 0, ENABLE);
	md_mcu_irq_config(SPI0_I2S0_IRQn, 0, ENABLE);
    __enable_irq();

    mcu_spi_init();     /* Initialize the SPI module */

    status = flash_sector_erase(0);

    if (status == MD_OK)
        flash_wait_unbusy();    /* Waiting for erasing */

    g_flash_data_size = strlen(s_flash_txbuf);

    status = flash_write(0, s_flash_txbuf, g_flash_data_size);

    if (status == MD_OK)
        flash_wait_unbusy();    /*Waiting for the written to complete*/

    status = flash_read(0, g_flash_data_size);   /*Read write data*/

    while (1);
}

/**
  * @} Examples_SPI
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
