/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    13 Dec. 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          13 Dec. 2022    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uint32_t g_sysclk;
uint32_t g_pclk;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of HSCO.
  * @retval None
  */
void md_hsco_pin_init(void)
{
    md_gpio_init_t gpio_init;

    /* initialize the HSCO */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_4;
    md_gpio_init(HSCO_PORT, HSCO_PIN, &gpio_init);

    return;
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);

    MD_SYSCFG_UNLOCK();
    md_cmu_enable_pll_unlock_manage();

    md_cmu_enable_perh_all(); /* Enable ALL peripheral */
    md_cmu_set_hsco_div(7);   /* 7: HSC / 128 */
    md_cmu_set_hsco_type(4);  /* 4: SYSCLK */
    md_cmu_enable_hsco();     /* Enable HSC output */

    /* Enable interrupt */
    md_cmu_enable_pll_unlock_interrupt();
    md_cmu_enable_pll_nmi_interrupt();

    /* get current clock */
    g_sysclk = md_cmu_get_sys_clock();
    g_pclk = md_cmu_get_pclk_clock();

    /* set the clock divider */
    md_cmu_div_config(MD_CMU_SYS, MD_CMU_DIV_2);   /* Fclk / 2 */
    md_cmu_div_config(MD_CMU_PCLK, MD_CMU_DIV_2);  /* Fclk / 2 */

    /* get current clock */
    g_sysclk = md_cmu_get_sys_clock();
    g_pclk = md_cmu_get_pclk_clock();

    MD_SYSCFG_LOCK();

    /* Initialize pin */
    md_hsco_pin_init();

    /* enable CMU IRQ */
    csi_vic_set_prio(CMU_IRQn, 2);
    csi_vic_enable_sirq(CMU_IRQn);
    __enable_irq();

    while (1)
    {
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
