/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    12 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 Jan. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  CLINT IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) CLINT_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    csi_coret_clr(md_cmu_get_clock() / 1000, CLINT_IRQn);
    md_inc_tick();

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @brief  DMA_Handler
  * @retval None
  */
void __attribute__((interrupt)) DMA_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    MD_NEST_INT_START();

    if (md_dma_is_active_flag_tc(MD_DMA_CH_3))
    {
        md_dma_clear_flag_tc(MD_DMA_CH_3);

        g_dma_flag = 1;
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    MD_NEST_INT_END();

    return;
}

/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
