/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    17 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
#include "smart_card.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
ald_uart_handle_t g_h_uart;

uint8_t g_tx_buf[32];
uint8_t g_rx_buf[32];
uint8_t g_SMART_CARD_OK = 0U;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void init_uart_pin(void)
{
    ald_gpio_init_t gpio_init;
    memset(&gpio_init, 0x00, sizeof(ald_gpio_init_t));

    /* Initialize IO(TX) pin */
    gpio_init.mode  = ALD_GPIO_MODE_OUTPUT;
    gpio_init.od    = ALD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = ALD_GPIO_PUSH_UP;
    gpio_init.odrv  = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_5;
    ald_gpio_init(CARD_IO_PORT, CARD_IO_PIN, &gpio_init);

    /* Initialize RST pin */
    gpio_init.mode  = ALD_GPIO_MODE_OUTPUT;
    gpio_init.od    = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_PUSH_UP;
    gpio_init.odrv  = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_1;
    ald_gpio_init(CARD_RST_PORT, CARD_RST_PIN, &gpio_init);

    /* Initialize CLK pin */
    gpio_init.mode  = ALD_GPIO_MODE_OUTPUT;
    gpio_init.od    = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_PUSH_UP;
    gpio_init.odrv  = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_2;
    ald_gpio_init(CARD_CLK_PORT, CARD_CLK_PIN, &gpio_init);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    uint16_t cnt1, cnt2;

    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);

    /* Enable all peripherals */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    __enable_irq();

    /* Initialize pin */
    init_uart_pin();

    memset(&g_h_uart, 0x00, sizeof(ald_uart_handle_t));
    /* Initialize uart */
    g_h_uart.perh             = UARTX;
    g_h_uart.init.baud        = 32258;  /* PCLK/4/372 */
    g_h_uart.init.word_length = ALD_UART_WORD_LENGTH_8B;
    g_h_uart.init.stop_bits   = ALD_UART_STOP_BITS_1_5;
    g_h_uart.init.parity      = ALD_UART_PARITY_EVEN;
    g_h_uart.init.mode        = ALD_UART_MODE_SCARD;
    g_h_uart.init.fctl        = ALD_UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&g_h_uart);

    ALD_UART_ENABLE_SCARD_CLK(&g_h_uart);
    ALD_UART_ENABLE_SCARD_NACK(&g_h_uart);
    MODIFY_REG(g_h_uart.perh->SCARD, UART_SCARD_GT_MSK, 2 << UART_SCARD_GT_POSS);
    MODIFY_REG(g_h_uart.perh->SCARD, UART_SCARD_PSC_MSK, 1 << UART_SCARD_PSC_POSS);
    ALD_UART_SCARD_ENABLE(&g_h_uart);
    ald_uart_clear_flag_status(&g_h_uart, ALD_UART_IF_TBC);

    cnt1 = 4000;

    while ((reset_rec(g_rx_buf) == CARD_ERROR) && (--cnt1));

    cnt2 = 4000;

    while ((instruction_test() == CARD_ERROR) && (--cnt2));

    if (cnt1 > 0 && cnt2 > 0)
        g_SMART_CARD_OK = 1;

    while (1)
    {
        ald_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
