/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    09 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include "main.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */
dma_callback_func g_dma_tc_callbacks[DMA_CHANNELS] = {0};
dma_callback_func g_dma_ht_callbacks[DMA_CHANNELS] = {0};
void *g_dma_tc_callback_datas[DMA_CHANNELS];
void *g_dma_ht_callback_datas[DMA_CHANNELS];

/* Private Function---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  CLINT IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) CLINT_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    ALD_NEST_INT_START();

    csi_coret_clr(ald_cmu_get_clock() / 1000, CLINT_IRQn);
    ald_inc_tick();

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    ALD_NEST_INT_END();

    return;
}

/**
  * @brief  DMA IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) DMA_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    ALD_NEST_INT_START();

    for (uint32_t ch = 0; ch < DMA_CHANNELS; ch++)
    {
        if (ald_dma_get_flag_status(ch, ALD_DMA_IT_FLAG_TC))
        {
            /* CHx TC */
            ald_dma_clear_flag_status(ch, ALD_DMA_IT_FLAG_TC);

            if (g_dma_tc_callbacks[ch])
                g_dma_tc_callbacks[ch](g_dma_tc_callback_datas[ch]);
        }

        if (ald_dma_get_flag_status(ch, ALD_DMA_IT_FLAG_HT))
        {
            /* CHx HT */
            ald_dma_clear_flag_status(ch, ALD_DMA_IT_FLAG_HT);

            if (g_dma_ht_callbacks[ch])
                g_dma_ht_callbacks[ch](g_dma_ht_callback_datas[ch]);
        }
    }

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    ALD_NEST_INT_END();

    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
