/**
  *********************************************************************************
  *
  * @file    uart.h
  * @brief   UART for debug printf
  *
  * @version V1.0
  * @date    09 Mar. 2023
  * @author  shiwa
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          09 Mar. 2023    Lisq            The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __UART_H__
#define   __UART_H__
/* Includes ---------------------------------------------------------------- */
#include <stdio.h>
#include "ald_gpio.h"
#include "ald_uart.h"

/* Exported Types ---------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

/* UART0 config & pins */
#define M_UART CUART1
#define M_UART_BAUD 115200
#define M_UART_TX_PORT GPIOA
#define M_UART_TX_PIN  ALD_GPIO_PIN_2
#define M_UART_TX_FUNC ALD_GPIO_FUNC_2
#define M_UART_RX_PORT GPIOA
#define M_UART_RX_PIN  ALD_GPIO_PIN_3
#define M_UART_RX_FUNC ALD_GPIO_FUNC_2
#define M_UART_IRQ CUART1_IRQn
#define M_UART_HANDLER CUART1_Handler

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

/**
  * @brief  Init UART0 for printf/scanf
  * @retval None
  */
extern void init_uart(void);
/**
  * @brief  UART receive by interrupt
  */
extern void bsp_uart_recv(uint8_t *data, uint16_t len, uint16_t timeout);
/**
  * @brief  Check if received data
  */
uint32_t bsp_uart_recved(char *buf, int length);
#endif /* __UART_H_ */
