/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    09 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ---------------------------------------------------------------- */
#include "ald_conf.h"

/* Exported Types ---------------------------------------------------------- */
typedef void (*dma_callback_func)(void *);
extern dma_callback_func g_dma_tc_callbacks[DMA_CHANNELS];
extern dma_callback_func g_dma_ht_callbacks[DMA_CHANNELS];
extern void *g_dma_tc_callback_datas[DMA_CHANNELS];
extern void *g_dma_ht_callback_datas[DMA_CHANNELS];
/* Exported Macros ----------------------------------------------------------- */
#define I2S_WS_PORT  GPIOA
#define I2S_WS_PIN   GPIO_PIN_4
#define I2S_CK_PORT  GPIOA
#define I2S_CK_PIN   GPIO_PIN_5
#define I2S_MCK_PORT GPIOA
#define I2S_MCK_PIN  GPIO_PIN_8
#define I2S_SDI_PORT GPIOA
#define I2S_SDI_PIN  GPIO_PIN_6
#define I2S_SDO_PORT GPIOA
#define I2S_SDO_PIN  GPIO_PIN_7

#define I2C_SCL_PORT GPIOB
#define I2C_SCL_PIN  GPIO_PIN_2
#define I2C_SDA_PORT GPIOB
#define I2C_SDA_PIN  GPIO_PIN_3

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

#endif /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
