/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    6 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "bat.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate lvd.
  * @retval None
  */
void init_lvd_powerdown(void)
{
    ALD_SYSCFG_UNLOCK();
    ald_pmu_lvd_config(ALD_PMU_LVD_VOL_SEL_3_6, ALD_PMU_LVD_TRIGGER_HIGH_LEVEL, ENABLE);
    SET_BIT(PMU->LVDCR, PMU_LVDCR_LVDCIF_MSK); /* clear LVD interrupt flag */
    ALD_SYSCFG_LOCK();

    csi_vic_clear_pending_irq(LVD_IRQn);

    return;
}
/**
  * @brief  Pins initialization function
  * @retval None.
  */
void init_pin(void)
{
    ald_gpio_init_t gpio_init;
    ald_exti_init_t exti_init;

    /* Initialize GPIO as input */
    memset(&gpio_init, 0x0, sizeof(gpio_init));      /* initialize the gpio_init */
    gpio_init.mode  = ALD_GPIO_MODE_INPUT;
    gpio_init.od    = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_PUSH_UP;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_1;
    ald_gpio_init(PMU_EXTI_PORT, PMU_EXTI_PIN, &gpio_init);

    memset(&exti_init, 0x0, sizeof(exti_init));
    exti_init.filter      = ENABLE;  /* enable exit filter */
    exti_init.filter_time = 10U;     /* set filter times: ((10 + 1) * 2)CLOCK */
    ald_gpio_exti_init(PMU_EXTI_PORT, PMU_EXTI_PIN, &exti_init);

    ald_gpio_exti_interrupt_config(PMU_EXTI_PIN, ALD_EXTI_TRIGGER_RISING_EDGE, ENABLE);
    ald_mcu_irq_config(EXTI0_3_IRQn, 0, ENABLE);       /* enable NVIC EXTI0_3_IRQn */

    /* Initialize LED port */
    memset(&gpio_init, 0x0, sizeof(gpio_init));      /* initialize the gpio_init */
    gpio_init.mode = ALD_GPIO_MODE_OUTPUT;
    gpio_init.od   =   ALD_GPIO_PUSH_PULL;
    gpio_init.pupd = ALD_GPIO_FLOATING;
    gpio_init.odrv = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt  = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type = ALD_GPIO_TYPE_CMOS;
    gpio_init.func = ALD_GPIO_FUNC_1;

    ald_gpio_init(LED_PORT, LED_PIN, &gpio_init);
    ald_gpio_write_pin(LED_PORT, LED_PIN, 1U);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);

    /* Enable ALL peripheral */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    __enable_irq();

    init_lvd_powerdown();

    ald_delay_1ms(10);

    /* power is lower */
    if (READ_BIT(PMU->LVDCR, PMU_LVDCR_LVDIF_MSK) == PMU_LVDCR_LVDIF_MSK)
        bat_proc();

    init_pin();

    ald_mcu_irq_config(LVD_IRQn, 0, ENABLE);

    while (1)
    {
        ald_gpio_write_pin(LED_PORT, LED_PIN, 0U);
        ald_delay_1ms(500);
        ald_gpio_write_pin(LED_PORT, LED_PIN, 1U);
        ald_delay_1ms(500);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
