/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    6 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"


/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  CLINT IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) CLINT_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    ALD_NEST_INT_START();

    csi_coret_clr(ald_cmu_get_clock() / 1000, CLINT_IRQn);
    ald_inc_tick();

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    ALD_NEST_INT_END();

    return;
}

/**
  * @brief  LVD handler
  * @retval None
  */
void __attribute__((interrupt)) LVD_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    ALD_NEST_INT_START();

    ald_lvd_irq_handler();

    ald_rmu_reset_system();

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    ALD_NEST_INT_END();

    return;
}

/**
  * @brief  EXTI handler
  * @retval None
  */
void __attribute__((interrupt)) EXTI0_3_Handler(void)
{
    /* Nested IRQ start : Save CSR and enable global interrupt. */
    ALD_NEST_INT_START();

    /* exti2 interrupt */
    if (ald_gpio_exti_get_ie_status(PMU_EXTI_PIN) && ald_gpio_exti_get_flag_status(PMU_EXTI_PIN))
        ald_gpio_exti_clear_flag_status(PMU_EXTI_PIN);  /* clear exit2 interrupt flag */

    /* Nested IRQ end : Restore CSR and disable global interrupt. */
    ALD_NEST_INT_END();

    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
