/**********************************************************************************
 *
 * @file    bat.c
 * @brief   bat file for DEMO
 *
 * @date    6 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          6 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "bat.h"
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_PMU
  * @{
  */

/* Private Macros ------------------------------------------------------------ */
/* Only one macro can be opened at a time */
/* #define LP_MODE_SLEEP */
#define LP_MODE_STOP

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate lvd.
  * @retval None
  */
void init_lvd_powerup(void)
{
    ALD_SYSCFG_UNLOCK();
    ald_pmu_lvd_config(ALD_PMU_LVD_VOL_SEL_3_6, ALD_PMU_LVD_TRIGGER_LOW_LEVEL, ENABLE);
    SET_BIT(PMU->LVDCR, PMU_LVDCR_LVDCIF_MSK); /* clear LVD interrupt flag */
    ALD_SYSCFG_LOCK();

    csi_vic_clear_pending_irq(LVD_IRQn);

    ald_mcu_irq_config(LVD_IRQn, 0, ENABLE);

    return;
}

/**
  * @brief  Test battery function
  * @retval Status.
  */
void bat_proc(void)
{
    init_pin();
    init_lvd_powerup();

    while (1)
    {
#ifdef LP_MODE_SLEEP
        /* Prevent CLINT interrupt wake up sleep */
        csi_vic_disable_sirq(CLINT_IRQn);

        ald_pmu_sleep_enter();

        csi_vic_enable_sirq(CLINT_IRQn);
#endif /* LP_MODE_SLEEP */
#ifdef LP_MODE_STOP
        ald_pmu_stop_enter();
#endif /* LP_MODE_STOP */

        ald_gpio_write_pin(LED_PORT, LED_PIN, 0U);

        ald_delay_1ms(500);

        ald_gpio_write_pin(LED_PORT, LED_PIN, 1U);
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
