/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    09 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */
/* Only one macro can be opened at a time */
/* #define LP_MODE_SLEEP */
#define LP_MODE_STOP

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Pins initialization function
  * @retval None.
  */
void init_pin(void)
{
    ald_gpio_init_t gpio_init;
    ald_exti_init_t exti_init;
    memset(&gpio_init, 0x0, sizeof(gpio_init));
    memset(&exti_init, 0x0, sizeof(exti_init));

    /* Initialize GPIO as input */
    gpio_init.mode  = ALD_GPIO_MODE_INPUT;
    gpio_init.od    = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_PUSH_UP;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_1;
    ald_gpio_init(PMU_EXTI_PORT, PMU_EXTI_PIN, &gpio_init);

    /* Initialize external interrupt */
    exti_init.filter      = ENABLE;
    exti_init.filter_time = 10;
    ald_gpio_exti_init(PMU_EXTI_PORT, PMU_EXTI_PIN, &exti_init);

    /* Clear interrupt flag */
    ald_gpio_exti_clear_flag_status(PMU_EXTI_PIN);
    /* Configure interrupt */
    ald_gpio_exti_interrupt_config(PMU_EXTI_PIN, ALD_EXTI_TRIGGER_RISING_EDGE, ENABLE);

    /* enable NVIC EXTI0_3_IRQn */
    ald_mcu_irq_config(EXTI0_3_IRQn, 4, ENABLE);

    /* Initialize LED port */
    gpio_init.mode = ALD_GPIO_MODE_CLOSE;
    gpio_init.od   = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd = ALD_GPIO_FLOATING;
    gpio_init.odrv = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt  = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type = ALD_GPIO_TYPE_CMOS;
    gpio_init.func = ALD_GPIO_FUNC_0;

    ald_gpio_init(GPIOA, ALD_GPIO_PIN_0, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_1, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_2, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_3, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_4, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_5, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_6, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_7, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_8, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_9, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_10, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_11, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_12, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_13, &gpio_init);
    ald_gpio_init(GPIOA, ALD_GPIO_PIN_14, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_0, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_1, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_2, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_3, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_4, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_5, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_6, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_7, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_8, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_9, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_10, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_11, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_12, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_13, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_14, &gpio_init);
    ald_gpio_init(GPIOB, ALD_GPIO_PIN_15, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_0, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_1, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_2, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_3, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_4, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_5, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_6, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_7, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_8, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_9, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_10, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_11, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_12, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_13, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_14, &gpio_init);
    ald_gpio_init(GPIOC, ALD_GPIO_PIN_15, &gpio_init);
    ald_gpio_init(GPIOD, ALD_GPIO_PIN_0, &gpio_init);
    ald_gpio_init(GPIOD, ALD_GPIO_PIN_1, &gpio_init);

    gpio_init.mode = ALD_GPIO_MODE_OUTPUT;
    gpio_init.func = ALD_GPIO_FUNC_1;
    ald_gpio_init(LED_PORT, LED_PIN, &gpio_init);
    ald_gpio_write_pin(LED_PORT, LED_PIN, 1);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);

    /* Enable ALL peripheral */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    /* Pin initialization */
    init_pin();

    __enable_irq();

    while (1)
    {
        ald_gpio_write_pin(LED_PORT, LED_PIN, 0);
        ald_delay_1ms(500);
        ald_gpio_write_pin(LED_PORT, LED_PIN, 1);
        ald_delay_1ms(500);

        /* Enter low power mode */
#ifdef LP_MODE_SLEEP
        /* Prevent CLINT interrupt wake up sleep */
        csi_vic_disable_sirq(CLINT_IRQn);

        ald_pmu_sleep_enter();

        csi_vic_enable_sirq(CLINT_IRQn);
#endif /* LP_MODE_SLEEP */

#ifdef LP_MODE_STOP
        ald_pmu_stop_enter();
#endif /* LP_MODE_STOP */
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/