/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    06 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          06 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
ald_adc_handle_t g_adc_config;
ald_adc_timer_config_t g_timer_config;
uint32_t g_adc_result;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
/**
  * @brief  Adc insert convert complete.
  * @param  arg: Pointer to adc_handle_t structure.
  * @retval None.
  */
void insert_convert_complete(ald_adc_handle_t *arg)
{
    g_adc_result = ald_adc_insert_get_value(&g_adc_config, ALD_ADC_ICH_IDX_1) * VDD / 4095;
    return;
}

/**
  * @brief  Initialize the ADC Pins.
  * @param  None
  * @retval None
  */
void init_adc_pin(void)
{
    /* Initialize adc gpio pin */
    ald_gpio_init_t gpio_init;
    memset(&gpio_init, 0x0, sizeof(ald_gpio_init_t));
    gpio_init.mode = ALD_GPIO_MODE_CLOSE;
    gpio_init.pupd = ALD_GPIO_FLOATING;
    gpio_init.odrv = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt  = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type = ALD_GPIO_TYPE_CMOS;
    gpio_init.func = ALD_GPIO_FUNC_0;
    ald_gpio_init(ADC_IN_PORT, ADC_IN_PIN, &gpio_init);

    return;
}

/**
  * @brief  Configure the PIS.
  * @param  None
  * @retval None
  */
void config_timer_trig_adc(void)
{
    memset(&g_timer_config, 0x0, sizeof(ald_adc_timer_config_t));
    /* Config timer trigger adc function */
    g_timer_config.p_adc        = ADC;
    g_timer_config.adc_ch       = ALD_ADC_CHANNEL_6;
    g_timer_config.n_ref        = ALD_ADC_NEG_REF_VSS;
    g_timer_config.p_ref        = ALD_ADC_POS_REF_VDD;
    g_timer_config.p_timer      = AD16C4T;
    g_timer_config.time         = 200;
    ald_adc_timer_trigger_insert(&g_timer_config);

    return;
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);

    /* Enable ALL peripheral */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    ald_mcu_irq_config(ADC_IRQn, 4, ENABLE);
    __enable_irq();

    /* Initialize ADC gpio */
    init_adc_pin();

    /* Config PIS */
    config_timer_trig_adc();

    g_adc_config.perh = ADC;
    g_adc_config.insert_cplt_cbk = insert_convert_complete;
    ald_adc_interrupt_config(&g_adc_config, ALD_ADC_IT_ICH, ENABLE);

    while (1)
    {
        ald_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
