/**********************************************************************************
 *
 * @file    uart.c
 * @brief   Main file for DEMO
 *
 * @date    15 Mar. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          15 Mar. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <stdio.h>
#include "uart.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static ald_uart_handle_t s_uart;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void init_uart_pin(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  uart function
  * @retval None.
  */
void init_mcu_uart(void)
{
    init_uart_pin();

    s_uart.perh             = CUART1;
    s_uart.init.mode        = ALD_UART_MODE_UART;
    s_uart.init.baud        = 115200;       /*115200 8 1 N*/
    s_uart.init.word_length = ALD_UART_WORD_LENGTH_8B;
    s_uart.init.stop_bits   = ALD_UART_STOP_BITS_1;
    s_uart.init.parity      = ALD_UART_PARITY_NONE;
    s_uart.init.fctl        = ALD_UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&s_uart);         /*Initialization and enabled UART0*/
}

/**
  * @brief  uart pin function
  * @retval None.
  */
static void init_uart_pin(void)
{
    ald_gpio_init_t ald_gpio;

    ald_gpio.func = ALD_GPIO_FUNC_2;
    ald_gpio.mode = ALD_GPIO_MODE_OUTPUT;
    ald_gpio.od   = ALD_GPIO_PUSH_PULL;
    ald_gpio.pupd = ALD_GPIO_PUSH_UP;
    ald_gpio.type = ALD_GPIO_TYPE_CMOS;
    ald_gpio.odrv = ALD_GPIO_OUT_DRIVE_NORMAL;
    ald_gpio.flt  = ALD_GPIO_FILTER_DISABLE;
    ald_gpio_init(UART_TX_PORT, UART_TX_PIN, &ald_gpio);     /*Initializes the TX pin*/
}

int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        cnt = 4000;

        while (!ald_uart_get_status(&s_uart, ALD_UART_STATUS_TFEMPTY) && (--cnt));

        s_uart.perh->TXBUF = *ptr_char++;
    }

    return len;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
