/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    23 Feb. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Feb. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <string.h>
#include "ald_conf.h"

/* Exported Macros ----------------------------------------------------------- */
/* I2C IO pin definition */
#define I2C_SCL_PORT  GPIOB
#define I2C_SCL_PIN   ALD_GPIO_PIN_2
#define I2C_SDA_PORT  GPIOB
#define I2C_SDA_PIN   ALD_GPIO_PIN_3

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern ald_i2c_handle_t g_ald_i2c;
extern uint8_t g_recv_buf[20];
extern uint32_t g_recv_len;
extern uint32_t g_recv_inc;
extern uint8_t g_send_buf[20];
extern uint32_t g_send_len;
extern uint32_t g_send_inc;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
