/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    16 Feb. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          16 Feb. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
static void gpio_init(void)
{
    ald_gpio_init_t gpio_init;

    /* initialize the gpio_init */
    memset(&gpio_init, 0x0, sizeof(gpio_init));
    /* Initialize LED pin */
    gpio_init.mode  = ALD_GPIO_MODE_OUTPUT;
    gpio_init.od    = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_FLOATING;
    gpio_init.odrv  = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_1;
    ald_gpio_init(LED_PORT, LED_PIN, &gpio_init);

    /* initialize the gpio_init */
    memset(&gpio_init, 0x0, sizeof(gpio_init));
    /* Initialize KEY pin */
    gpio_init.mode  = ALD_GPIO_MODE_INPUT;
    gpio_init.od    = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_PUSH_DOWN;
    gpio_init.odrv  = ALD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_1;
    ald_gpio_init(KEY_PORT, KEY_PIN, &gpio_init);

    return;
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main(void)
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);

    /* Enable ALL peripheral */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    /* Initialize pin */
    gpio_init();

    while (1)
    {
        if (ald_gpio_read_pin(KEY_PORT, KEY_PIN))
            ald_gpio_write_pin(LED_PORT, LED_PIN, 1);
        else
            ald_gpio_write_pin(LED_PORT, LED_PIN, 0);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
