/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    21 Feb. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          21 Feb. 2023    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
char g_src[64] = "Hello world!";
char g_dst[64] = {0};

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    ald_dma_handle_t dma_handle;

    /* Initialize ALD */
    ald_cmu_init();

    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC8M, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);

    /* Enable all peripherals */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    memset(&dma_handle, 0x0, sizeof(ald_dma_handle_t));
    dma_handle.config.src            = g_src;
    dma_handle.config.dst            = g_dst;
    dma_handle.config.size           = strlen(g_src);
    dma_handle.config.src_data_width = ALD_DMA_DATA_SIZE_BYTE;
    dma_handle.config.dst_data_width = ALD_DMA_DATA_SIZE_BYTE;
    dma_handle.config.src_inc        = ALD_DMA_DATA_INC_ENABLE;
    dma_handle.config.dst_inc        = ALD_DMA_DATA_INC_ENABLE;
    dma_handle.config.R_power        = ALD_DMA_R_POWER_1;
    dma_handle.config.priority       = ALD_DMA_HIGHEST_PRIORITY;
    dma_handle.config.mem_to_mem     = ENABLE;
    dma_handle.config.circle_mode    = DISABLE;
    dma_handle.config.msel           = ALD_DMA_MSEL_NONE;
    dma_handle.config.msigsel        = ALD_DMA_MSIGSEL_NONE;
    dma_handle.config.channel        = ALD_DMA_CH_0;
    ald_dma_config_basic(&dma_handle);

    while (1);
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
