/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    17 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Jan. 2023    Shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <rtthread.h>
#include "drv_uart.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Init UART pin
  * @retval None
  */
void uart_pin_init(void)
{
    md_gpio_init_t gpio_init;
    md_gpio_init_struct(&gpio_init);

    /* Initialize tx pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_2;
    md_gpio_init(UART_TX_PORT, UART_TX_PIN, &gpio_init);

    /* Initialize rx pin */
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_2;
    md_gpio_init(UART_RX_PORT, UART_RX_PIN, &gpio_init);
}
/**
  * @brief:  Initialize the uart.
  * @param:  None
  * @retval: None
  */
void uart_init(void)
{
    md_uart_init_t uart_init;
    md_uart_init_struct(&uart_init);

    /* Initialize UART */
    uart_init.baud        = 115200;  /* 冗余度: 110155 ~ 121452 */
    uart_init.word_length = MD_UART_WORD_LENGTH_8B;
    uart_init.stop_bits   = MD_UART_STOP_BITS_1;
    uart_init.parity      = MD_UART_PARITY_NONE;
    uart_init.fctl        = MD_UART_FLOW_CTL_DISABLE;
    uart_init.mode        = MD_UART_MODE;
    md_uart_init(UARTX, &uart_init);
}

void rt_hw_uart_init()
{
	uart_pin_init();
	uart_init();
}
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt; 
	(void)file;
	uint8_t *ptr_char = (uint8_t *)ptr;
	
	for(int i = 0 ; i < len ; i++)
	{
		if (*ptr_char == '\n')
		{
            cnt = 4000;
			while ((READ_BIT(UARTX->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK
			        && (--cnt))
			{
			}
			md_uart_set_send_data8(UARTX, '\r');
		}

        cnt = 4000;
        while ((READ_BIT(UARTX->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK
		        && (--cnt))
		{
		}
		md_uart_set_send_data8(UARTX, *ptr_char++);
	}

	return len;
}
void _putchar(char chr)
{
	while (!md_uart_is_active_flag_tfempty(UARTX));
	md_uart_set_send_data8(UARTX, (uint8_t)chr);
}

void rt_hw_console_output(const char *str)
{
    rt_size_t len = 0;
    char *sptr = (char *)str;

    len = rt_strlen(str);

    while (len--)
    {
        if (*sptr == '\n')
			_putchar('\r');

        _putchar(*(sptr++));
    }
}

#ifdef RT_USING_FINSH

static int uart_getc(struct es32_uart *uart)
{
    int ch = -1;

    return ch;
}

char rt_hw_console_getchar(void)
{
    if (!console_uart)return -1;

    return es32f3x_getc(console_uart);
}

#endif /* RT_USING_FINSH */