/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    9 Feb. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          9 Feb. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */


/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include "main.h"

/* Public Variables ---------------------------------------------------------- */

/* Public Function ---------------------------------------------------------- */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables--------------------------------------------------------- */

static md_uart_init_t s_uart_init;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  init pins used for uart.
  * @param  None
  * @retval None
  */
void uart_pins_init(void)
{
    md_gpio_init_t gpio_init;

    /* Initialize tx pin */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_2;
    md_gpio_init(UART_PORT, TX_PIN, &gpio_init);

    /* Initialize rx pin */
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_2;
    md_gpio_init(UART_PORT, RX_PIN, &gpio_init);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
#ifdef USE_CRC32
    uint32_t app_len = 0U;
#endif/*USE_CRC32*/

    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    /* Config uart interrupt */
    md_mcu_irq_config(CUART1_IRQn, 4, ENABLE);
    __enable_irq();

    /* Init communication parameters */
    uart_pins_init();
    md_uart_init_struct(&s_uart_init);
    s_uart_init.parity = MD_UART_PARITY_EVEN;
    md_uart_init(COMMUNICATION_TYPE, &s_uart_init);

    md_uart_set_abrmod(COMMUNICATION_TYPE, 1);
    md_uart_enable_abr(COMMUNICATION_TYPE);

    /* Init state machine */
    fsm_comm_func_init();
    fsm_exec_func_init();
    fsm_para_init();

#ifdef USE_CRC32
    /* If APP is valid, jump to APP. */
    app_len = *((uint32_t *)CRC_CAL_ADDR + 1);

    if (app_len <= (CRC_CAL_ADDR - APP_ADDR))
    {
        if (verify_valid() == PASS)
            g_isp_data.p_go(APP_CMD);
    }

#else
    g_isp_data.p_go(APP_CMD);
#endif/*USE_CRC32*/

    while (1)
    {
        while (fsm_is_trigger())
        {
            proc_fsm();
        }
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/