/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    9 Feb. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          9 Feb. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */

#include "md_conf.h"

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_flag;

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define COMMUNICATION_TYPE SPI0

#define SPI_NSS_PORT  GPIOA
#define SPI_NSS_PIN  MD_GPIO_PIN_4
#define SPI_SCK_PORT  GPIOA
#define SPI_SCK_PIN  MD_GPIO_PIN_5
#define SPI_MISO_PORT  GPIOA
#define SPI_MISO_PIN MD_GPIO_PIN_6
#define SPI_MOSI_PORT  GPIOA
#define SPI_MOSI_PIN MD_GPIO_PIN_7

#define LED_PORT GPIOA
#define LED_PIN MD_GPIO_PIN_15

#define APP_ADDR      0x00000000
#define BOOT_ADDR     0x0003C000
#define CRC_CAL_ADDR  0x0003BE00

#define GO_APP       0xFFFFFFFE
#define GO_BOOT      0xFFFFFFFD

#define POS_ACK 0x79
#define NEG_ACK 0x1F

#define FRAME_INTERVAL   500

#endif  /* __MAIN_H__ */
