/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "es_example_conf.h"
#include "lvgl.h"
#include "es_st7789.h"
#include "es_gt91x.h"
#include "md_csu.h"
#include "md_rmu.h"
#include "ald_usb.h"
#include "es_spi_flash.h"
/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
uint16_t g_dma_used_color;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

void pis_config(void)
{
    md_pis_init_t pis_init;
    memset(&pis_init, 0, sizeof(md_pis_init_t));

    MD_SYSCFG_UNLOCK();
    md_syscfg_pisiocfg_io5sel(SYSCFG, MD_SYSCFG_PISIOCFG_PA);
    md_syscfg_pisiocfg_io6sel(SYSCFG, MD_SYSCFG_PISIOCFG_PA);
    MD_SYSCFG_LOCK();

    md_pis_enable_ch5_output(PIS);
    md_pis_enable_ch7_output(PIS);

    pis_init.p_src     = MD_PIS_GPIO_PIN5;
    pis_init.p_clk     = MD_PIS_CLK_HCLK;
    pis_init.p_edge    = MD_PIS_EDGE_NONE;
    pis_init.p_output  = MD_PIS_OUT_LEVEL;
    pis_init.c_trig    = 0x5;
    pis_init.c_clk     = MD_PIS_CLK_HCLK;
    md_pis_init(&pis_init);

    pis_init.p_src     = MD_PIS_GPIO_PIN6;
    pis_init.p_clk     = MD_PIS_CLK_HCLK;
    pis_init.p_edge    = MD_PIS_EDGE_NONE;
    pis_init.p_output  = MD_PIS_OUT_LEVEL;
    pis_init.c_trig    = 0x7;
    pis_init.c_clk     = MD_PIS_CLK_HCLK;
    md_pis_init(&pis_init);
}

void es_init_mcu_pin(void)
{
    pis_config();

#if ES_GUI_USE_TOUCH

    md_gpio_init_t gpio_init;

    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP_DOWN;
    gpio_init.odrv  = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;

    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;

    gpio_init.odos  = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;

    gpio_init.func  = ES_TOUCH_I2C_SDA_PIN_MD_FUNC;
    md_gpio_init(ES_TOUCH_I2C_SDA_PIN_PORT, ES_TOUCH_I2C_SDA_PIN_MD_PIN, &gpio_init);

    gpio_init.func  = ES_TOUCH_I2C_SCL_PIN_MD_FUNC;
    md_gpio_init(ES_TOUCH_I2C_SCL_PIN_PORT, ES_TOUCH_I2C_SCL_PIN_MD_PIN, &gpio_init);

#endif

    md_gpio_set_pin_low(ES_LCD_BL_PIN_PORT, ES_LCD_BL_PIN_MD_PIN);
    md_gpio_set_pin_high(ES_EXTERN_FLASH_CS_PIN_PORT, ES_EXTERN_FLASH_CS_PIN_MD_PIN);
}

void es_spi_datasize_8(SPI_I2S_TypeDef *SPIx)
{
    md_spi_disable(SPIx);
    md_spi_enable_8_byte_commumication(SPIx);
    md_spi_enable(SPIx);
}

void es_spi_datasize_16(SPI_I2S_TypeDef *SPIx)
{
    md_spi_disable(SPIx);
    md_spi_enable_16_byte_commumication(SPIx);
    md_spi_enable(SPIx);
}

void es_spi_fast(SPI_I2S_TypeDef *SPIx)
{
    md_spi_disable(SPIx);
    md_spi_set_commumication_baud(SPIx, MD_SPI_BAUD_2);
    md_spi_enable(SPIx);
}

void es_spi_normal(SPI_I2S_TypeDef *SPIx)
{
    md_spi_disable(SPIx);
    md_spi_set_commumication_baud(SPIx, MD_SPI_BAUD_4);
    md_spi_enable(SPIx);
}

#if ES_GUI_USE_TOUCH

void es_init_touch_exti(void)
{

}

#endif

void es_init_lcd_spi_dma(void)
{
    md_dma_config_t lcd_spi_dma_tx_config;

    memset(&lcd_spi_dma_tx_config, 0x0, sizeof(md_dma_config_t));
    lcd_spi_dma_tx_config.src            = (void *)(0);
    lcd_spi_dma_tx_config.dst            = (void *)(&ES_LCD_SPI_PERIPHERAL->DATA);
    lcd_spi_dma_tx_config.size           = 0;
    lcd_spi_dma_tx_config.src_data_width = MD_DMA_DATA_SIZE_HALFWORD;
    lcd_spi_dma_tx_config.dst_data_width = MD_DMA_DATA_SIZE_HALFWORD;
    lcd_spi_dma_tx_config.src_inc        = ENABLE;
    lcd_spi_dma_tx_config.dst_inc        = DISABLE;
    lcd_spi_dma_tx_config.R_power        = MD_DMA_R_POWER_1;
    lcd_spi_dma_tx_config.priority       = MD_DMA_LOW_PRIORITY;
    lcd_spi_dma_tx_config.mem_to_mem     = DISABLE;
    lcd_spi_dma_tx_config.circle_mode    = DISABLE;
    lcd_spi_dma_tx_config.msel           = MD_DMA_MSEL_SPI1;
    lcd_spi_dma_tx_config.msigsel        = MD_DMA_MSIGSEL_SPI_TXEMPTY;
    md_dma_init(MD_DMA_CH_0, &lcd_spi_dma_tx_config);

    /* Enable DMA */
    md_spi_enable_txdma(ES_LCD_SPI_PERIPHERAL);
}

void es_init_lcd_spi(void)
{

}

void es_lcd_wait_spi_over_cs1(void)
{
    while (((ES_LCD_SPI_PERIPHERAL->STAT & SPI_STAT_TXE_MSK) == 0));

    while (((ES_LCD_SPI_PERIPHERAL->STAT & SPI_STAT_BUSY_MSK)));

    md_gpio_set_pin_high(ES_LCD_SPI_SOFT_NSS_PIN_PORT, ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN);
}

void es_st7789_port_lcd_wrte_cmd(uint8_t cmd)
{
    md_gpio_set_pin_low(ES_LCD_CD_PIN_PORT, ES_LCD_CD_PIN_MD_PIN);
    md_gpio_set_pin_low(ES_LCD_SPI_SOFT_NSS_PIN_PORT, ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN);
    ES_LCD_SPI_PERIPHERAL->DATA = cmd;
    es_lcd_wait_spi_over_cs1();
}

void es_st7789_port_lcd_wrte_data(uint8_t data)
{
    md_gpio_set_pin_high(ES_LCD_CD_PIN_PORT, ES_LCD_CD_PIN_MD_PIN);
    md_gpio_set_pin_low(ES_LCD_SPI_SOFT_NSS_PIN_PORT, ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN);
    ES_LCD_SPI_PERIPHERAL->DATA = data;
    es_lcd_wait_spi_over_cs1();
}

#pragma GCC push_options
#pragma GCC optimize("O0" )

void es_lv_lcd_write_area(lv_disp_drv_t *disp_drv, const lv_area_t *area, lv_color_t *color_p)
{
    uint32_t size = (area->x2 - area->x1 + 1) * (area->y2 - area->y1 + 1);
    uint8_t temp8;
    uint16_t dma_transfer_num;
    uint16_t *buf = (uint16_t *)color_p;

    /*等待DMA完成*/
    while (DMA->CHANNEL[0].CON & 0x1) {}

    /*等待SPI传输完成*/
    es_lcd_wait_spi_over_cs1();

    /*SPI数据帧长度->8*/
    es_spi_datasize_8(ES_LCD_SPI_PERIPHERAL);

    es_st7789_lcd_write_area_cmd(area->x1, area->x2, area->y1, area->y2);

    /*SPI数据帧长度->16*/
    es_spi_datasize_16(ES_LCD_SPI_PERIPHERAL);

    /*LCD写像素数据+SPI片选*/
    md_gpio_set_pin_high(ES_LCD_CD_PIN_PORT, ES_LCD_CD_PIN_MD_PIN);
    md_gpio_set_pin_low(ES_LCD_SPI_SOFT_NSS_PIN_PORT, ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN);

    md_dma_set_source_inc(MD_DMA_CH_0, 1);

    /*SPI发送DMA开始*/
    while (size)
    {
        dma_transfer_num = (size > 65535) ? 65535 : size;
        md_dma_set_source_addr(MD_DMA_CH_0, buf);
        md_dma_set_transfer_size(MD_DMA_CH_0, dma_transfer_num);
        buf += dma_transfer_num;

        size -= dma_transfer_num;
        md_dma_enable_channel(MD_DMA_CH_0);

        /*等待DMA完成*/
        while (DMA->CHANNEL[0].CON & 0x1)
        {
        }
    }

    lv_disp_flush_ready(0);

    (void)temp8;
}

#pragma GCC pop_options

void es_st7789_write_area_one_color(uint16_t x1, uint16_t x2, uint16_t y1, uint16_t y2, uint16_t color)
{
    uint32_t size = (x2 - x1 + 1) * (y2 - y1 + 1);
    uint8_t temp8;
    uint16_t dma_transfer_num;

    g_dma_used_color = color;

    md_gpio_set_pin_high(ES_LCD_SPI_SOFT_NSS_PIN_PORT, ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN);

    /*SPI数据帧长度->8*/
    es_spi_datasize_8(ES_LCD_SPI_PERIPHERAL);

    es_st7789_lcd_write_area_cmd(x1, x2, y1, y2);

    /*SPI数据帧长度->16*/
    es_spi_datasize_16(ES_LCD_SPI_PERIPHERAL);

    /*LCD写像素数据+SPI片选*/
    md_gpio_set_pin_high(ES_LCD_CD_PIN_PORT, ES_LCD_CD_PIN_MD_PIN);
    md_gpio_set_pin_low(ES_LCD_SPI_SOFT_NSS_PIN_PORT, ES_LCD_SPI_SOFT_NSS_PIN_MD_PIN);

    /*SPI发送DMA开始*/
    md_dma_set_source_addr(MD_DMA_CH_0, (void *)&g_dma_used_color);
    md_dma_set_source_inc(MD_DMA_CH_0, 0);

    while (size)
    {
        dma_transfer_num = (size > 65535) ? 65535 : size;
        md_dma_set_transfer_size(MD_DMA_CH_0, dma_transfer_num);

        size -= dma_transfer_num;
        md_dma_enable_channel(MD_DMA_CH_0);

        /*等待DMA完成*/
        while (DMA->CHANNEL[0].CON & 0x1)
        {
        }
    }

    /*等待SPI传输完成*/
    es_lcd_wait_spi_over_cs1();

    /*SPI数据帧长度->8*/
    es_spi_datasize_8(ES_LCD_SPI_PERIPHERAL);

    (void)temp8;
}

#if ES_GUI_USE_TOUCH

void es_init_touch_gt91x(void)
{
    es_init_touch_exti();
    gt911_touch_reset();
    gt911_touch_default_config();
}

#endif

void es_init_lcd_st7789(void)
{
    es_init_lcd_spi();
    es_init_lcd_spi_dma();
    es_st7789_lcd_init();
}

void es_mcu_init(void)
{
    MD_SYSCFG_UNLOCK();
#if ES_USE_USB_MSC_DEV_UPDATE_SPI_FLASH
    md_cmu_enable_usbck48();        //USB 48M使能
    md_csu_enable_auto();
    md_csu_enable_cnt();
#endif
    MD_SYSCFG_LOCK();
#if ES_USE_USB_MSC_DEV_UPDATE_SPI_FLASH
    md_rmu_reset_periperal(MD_RMU_PERH_USB);
#endif
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    __enable_irq();

    es_init_mcu_pin();

    es_init_extern_flash();
    es_init_lcd_st7789();

#if ES_GUI_USE_TOUCH
    es_init_touch_gt91x();
#endif
}

void es_delay_1ms(uint32_t ms)
{
    md_delay_1us(ms * 1000);
}