
/*******************************************************************************
 *
 * @file    ui.c
 * @brief   ui C file
 *
 * @date    2025.05.21
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2025.05.21      AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *******************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include "ui.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */

/* Public Variables --------------------------------------------------------- */

lv_obj_t * g_ui_screen_1;
lv_obj_t * g_ui_label_4;
lv_obj_t * g_ui_button_5;
void ui_event_button_5(lv_event_t * e);
lv_obj_t * g_ui_label_5;
lv_obj_t * g_ui_button_6;
void ui_event_button_6(lv_event_t * e);
lv_obj_t * g_ui_label_6;
lv_obj_t * g_ui_screen_2;
lv_obj_t * g_ui_button_1;
lv_obj_t * g_ui_button_2;
lv_obj_t * g_ui_button_3;
lv_obj_t * g_ui_label_1;
lv_obj_t * g_ui_arc_2;
lv_obj_t * g_ui_label_2;
lv_obj_t * g_ui_slider_2;
lv_obj_t * g_ui_button_4;
void ui_event_button_4(lv_event_t * e);
lv_obj_t * g_ui_label_3;
lv_obj_t * g_ui_label_8;
lv_obj_t * g_ui_screen_3;
lv_obj_t * g_ui_imgbutton_2;
lv_obj_t * g_ui_button_9;
void ui_event_button_9(lv_event_t * e);
lv_obj_t * g_ui_button_10;
void ui_event_button_10(lv_event_t * e);
lv_obj_t * g_ui_label_9;
lv_obj_t * g_ui_label_10;
ES_GIF_CLASS_INFO_SECTION es_gif_info_t g_ui_gif_1;
const es_gif_info_t * g_es_gui_gifs_addr_table[] = 
{
	&g_ui_gif_1,

};
const uint32_t g_es_gui_gifs_addr_table_num = sizeof(g_es_gui_gifs_addr_table)/sizeof(es_gif_info_t *);


/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Public Function----------------------------------------------------------- */

/* Private Function---------------------------------------------------------- */

void ui_event_button_5(lv_event_t * e)
{
	lv_event_code_t event_code = lv_event_get_code(e);
	lv_obj_t * target = lv_event_get_target(e);
	if(event_code == LV_EVENT_CLICKED) {
		lv_scr_load_anim(g_ui_screen_2, LV_SCR_LOAD_ANIM_NONE, 0, 0, false);
	}
}
void ui_event_button_6(lv_event_t * e)
{
	lv_event_code_t event_code = lv_event_get_code(e);
	lv_obj_t * target = lv_event_get_target(e);
	if(event_code == LV_EVENT_CLICKED) {
		lv_scr_load_anim(g_ui_screen_3, LV_SCR_LOAD_ANIM_NONE, 0, 0, false);
	}
}
void ui_event_button_4(lv_event_t * e)
{
	lv_event_code_t event_code = lv_event_get_code(e);
	lv_obj_t * target = lv_event_get_target(e);
	if(event_code == LV_EVENT_CLICKED) {
		lv_scr_load_anim(g_ui_screen_1, LV_SCR_LOAD_ANIM_NONE, 0, 0, false);
	}
}
void ui_event_button_9(lv_event_t * e)
{
	lv_event_code_t event_code = lv_event_get_code(e);
	lv_obj_t * target = lv_event_get_target(e);
	if(event_code == LV_EVENT_PRESSED) {
		es_ui_set_gif_diable(&g_ui_gif_1, 1);
	}
	if(event_code == LV_EVENT_RELEASED) {
		es_ui_set_gif_enable(&g_ui_gif_1);
	}
}
void ui_event_button_10(lv_event_t * e)
{
	lv_event_code_t event_code = lv_event_get_code(e);
	lv_obj_t * target = lv_event_get_target(e);
	if(event_code == LV_EVENT_CLICKED) {
		lv_scr_load_anim(g_ui_screen_1, LV_SCR_LOAD_ANIM_NONE, 0, 0, false);
	}
}
void ui_screen_1_screen_init()
{
	g_ui_screen_1 = lv_obj_create(NULL);
	lv_obj_set_style_bg_img_src(g_ui_screen_1, &g_test_img0, LV_PART_MAIN | LV_STATE_DEFAULT);

	g_ui_label_4 = lv_label_create(g_ui_screen_1);
	lv_obj_set_width(g_ui_label_4, 180);
	lv_obj_set_height(g_ui_label_4, 70);
	lv_obj_set_x(g_ui_label_4, 56);
	lv_obj_set_y(g_ui_label_4, 0);
	lv_label_set_text(g_ui_label_4, "essemi");
	lv_label_set_long_mode(g_ui_label_4, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_4, lv_color_hex(0xff0000), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_4, &g_test_font0_48, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_4, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_4, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_4, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_4, LV_TEXT_ALIGN_CENTER, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_4, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_4, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_4, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_4, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_button_5 = lv_btn_create(g_ui_screen_1);
	lv_obj_set_width(g_ui_button_5, 80);
	lv_obj_set_height(g_ui_button_5, 60);
	lv_obj_set_x(g_ui_button_5, 25);
	lv_obj_set_y(g_ui_button_5, 78);
	lv_obj_set_style_bg_color(g_ui_button_5, lv_color_hex(0x0000ff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_5, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_5, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_5, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_5, lv_color_hex(0x01a2b1), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_5, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_5, 2, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_5, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_5, 30, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	lv_obj_add_event_cb(g_ui_button_5, ui_event_button_5, LV_EVENT_ALL, NULL);
	g_ui_label_5 = lv_label_create(g_ui_screen_1);
	lv_obj_set_width(g_ui_label_5, 70);
	lv_obj_set_height(g_ui_label_5, 40);
	lv_obj_set_x(g_ui_label_5, 29);
	lv_obj_set_y(g_ui_label_5, 87);
	lv_label_set_text(g_ui_label_5, "例子1");
	lv_label_set_long_mode(g_ui_label_5, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_5, lv_color_hex(0xffffff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_5, &g_test_font0_24, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_5, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_5, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_5, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_5, LV_TEXT_ALIGN_CENTER, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_5, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_5, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_5, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_5, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_button_6 = lv_btn_create(g_ui_screen_1);
	lv_obj_set_width(g_ui_button_6, 80);
	lv_obj_set_height(g_ui_button_6, 60);
	lv_obj_set_x(g_ui_button_6, 184);
	lv_obj_set_y(g_ui_button_6, 81);
	lv_obj_set_style_bg_color(g_ui_button_6, lv_color_hex(0x0000ff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_6, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_6, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_6, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_6, lv_color_hex(0x01a2b1), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_6, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_6, 2, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_6, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_6, 30, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	lv_obj_add_event_cb(g_ui_button_6, ui_event_button_6, LV_EVENT_ALL, NULL);
	g_ui_label_6 = lv_label_create(g_ui_screen_1);
	lv_obj_set_width(g_ui_label_6, 70);
	lv_obj_set_height(g_ui_label_6, 40);
	lv_obj_set_x(g_ui_label_6, 189);
	lv_obj_set_y(g_ui_label_6, 91);
	lv_label_set_text(g_ui_label_6, "例子2");
	lv_label_set_long_mode(g_ui_label_6, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_6, lv_color_hex(0xffffff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_6, &g_test_font0_24, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_6, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_6, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_6, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_6, LV_TEXT_ALIGN_CENTER, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_6, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_6, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_6, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_6, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	

}
void ui_screen_2_screen_init()
{
	g_ui_screen_2 = lv_obj_create(NULL);
	lv_obj_set_style_bg_color(g_ui_screen_2, lv_color_hex(0x464b55), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_screen_2, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_screen_2, lv_color_hex(0x654321), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_screen_2, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);

	g_ui_button_1 = lv_btn_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_button_1, 160);
	lv_obj_set_height(g_ui_button_1, 160);
	lv_obj_set_x(g_ui_button_1, 80);
	lv_obj_set_y(g_ui_button_1, 40);
	lv_obj_set_style_bg_color(g_ui_button_1, lv_color_hex(0x1e232d), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_1, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_1, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_1, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_1, lv_color_hex(0x01a2b1), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_1, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_1, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_1, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_1, 80, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_button_2 = lv_btn_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_button_2, 120);
	lv_obj_set_height(g_ui_button_2, 120);
	lv_obj_set_x(g_ui_button_2, 100);
	lv_obj_set_y(g_ui_button_2, 60);
	lv_obj_set_style_bg_color(g_ui_button_2, lv_color_hex(0x646464), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_2, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_2, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_2, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_2, lv_color_hex(0x01a2b1), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_2, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_2, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_2, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_2, 60, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_button_3 = lv_btn_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_button_3, 90);
	lv_obj_set_height(g_ui_button_3, 90);
	lv_obj_set_x(g_ui_button_3, 115);
	lv_obj_set_y(g_ui_button_3, 75);
	lv_obj_set_style_bg_color(g_ui_button_3, lv_color_hex(0x0c191e), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_3, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_3, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_3, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_3, lv_color_hex(0x01a2b1), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_3, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_3, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_3, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_3, 45, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_label_1 = lv_label_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_label_1, 200);
	lv_obj_set_height(g_ui_label_1, 20);
	lv_obj_set_x(g_ui_label_1, 0);
	lv_obj_set_y(g_ui_label_1, 0);
	lv_label_set_text(g_ui_label_1, "2025/09/05  周五");
	lv_label_set_long_mode(g_ui_label_1, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_1, lv_color_hex(0xffffff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_1, &g_test_font0_12, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_1, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_1, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_1, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_1, LV_TEXT_ALIGN_LEFT, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_1, lv_color_hex(0x14191e), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_1, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_1, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_1, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_arc_2 = lv_arc_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_arc_2, 150);
	lv_obj_set_height(g_ui_arc_2, 150);
	lv_obj_set_x(g_ui_arc_2, 85);
	lv_obj_set_y(g_ui_arc_2, 45);
	lv_arc_set_range(g_ui_arc_2, 10, 50);
	lv_arc_set_value(g_ui_arc_2, 23);
	lv_arc_set_bg_angles(g_ui_arc_2, 60, 360);
	lv_arc_set_rotation(g_ui_arc_2, 60);
	lv_obj_set_style_arc_color(g_ui_arc_2, lv_color_hex(0x0f1215), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_arc_opa(g_ui_arc_2, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_arc_width(g_ui_arc_2, 10, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_arc_color(g_ui_arc_2, lv_color_hex(0x36b9f6), LV_PART_INDICATOR | LV_STATE_DEFAULT);
	lv_obj_set_style_arc_opa(g_ui_arc_2, 255, LV_PART_INDICATOR | LV_STATE_DEFAULT);
	lv_obj_set_style_arc_width(g_ui_arc_2, 10, LV_PART_INDICATOR | LV_STATE_DEFAULT);
	
	g_ui_label_2 = lv_label_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_label_2, 90);
	lv_obj_set_height(g_ui_label_2, 60);
	lv_obj_set_x(g_ui_label_2, 125);
	lv_obj_set_y(g_ui_label_2, 90);
	lv_label_set_text(g_ui_label_2, "23°");
	lv_label_set_long_mode(g_ui_label_2, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_2, lv_color_hex(0xffffff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_2, &g_test_font1_48, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_2, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_2, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_2, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_2, LV_TEXT_ALIGN_CENTER, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_2, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_2, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_2, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_2, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_slider_2 = lv_slider_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_slider_2, 280);
	lv_obj_set_height(g_ui_slider_2, 10);
	lv_obj_set_x(g_ui_slider_2, 15);
	lv_obj_set_y(g_ui_slider_2, 215);
	lv_slider_set_range(g_ui_slider_2, 0, 100);
	lv_slider_set_value(g_ui_slider_2, 50, LV_ANIM_OFF);
	lv_obj_set_style_bg_color(g_ui_slider_2, lv_color_hex(0x0f1215), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_slider_2, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_slider_2, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_slider_2, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_slider_2, lv_color_hex(0x37b9f5), LV_PART_INDICATOR | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_slider_2, 255, LV_PART_INDICATOR | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_slider_2, lv_color_hex(0x1464f0), LV_PART_INDICATOR | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_slider_2, LV_GRAD_DIR_HOR, LV_PART_INDICATOR | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_slider_2, lv_color_hex(0x5f6464), LV_PART_KNOB | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_slider_2, 255, LV_PART_KNOB | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_slider_2, lv_color_hex(0x3c424b), LV_PART_KNOB | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_slider_2, LV_GRAD_DIR_VER, LV_PART_KNOB | LV_STATE_DEFAULT);
	lv_obj_set_style_pad_ver(g_ui_slider_2, 5, LV_PART_KNOB);
	
	g_ui_button_4 = lv_btn_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_button_4, 80);
	lv_obj_set_height(g_ui_button_4, 60);
	lv_obj_set_x(g_ui_button_4, 236);
	lv_obj_set_y(g_ui_button_4, 31);
	lv_obj_set_style_bg_color(g_ui_button_4, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_4, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_4, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_4, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_4, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_4, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_4, 2, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_4, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_4, 30, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	lv_obj_add_event_cb(g_ui_button_4, ui_event_button_4, LV_EVENT_ALL, NULL);
	g_ui_label_3 = lv_label_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_label_3, 60);
	lv_obj_set_height(g_ui_label_3, 40);
	lv_obj_set_x(g_ui_label_3, 245);
	lv_obj_set_y(g_ui_label_3, 40);
	lv_label_set_text(g_ui_label_3, "返回");
	lv_label_set_long_mode(g_ui_label_3, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_3, lv_color_hex(0xffffff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_3, &g_test_font0_24, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_3, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_3, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_3, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_3, LV_TEXT_ALIGN_CENTER, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_3, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_3, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_3, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_3, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_label_8 = lv_label_create(g_ui_screen_2);
	lv_obj_set_width(g_ui_label_8, 120);
	lv_obj_set_height(g_ui_label_8, 20);
	lv_obj_set_x(g_ui_label_8, 200);
	lv_obj_set_y(g_ui_label_8, 0);
	lv_label_set_text(g_ui_label_8, "15:43");
	lv_label_set_long_mode(g_ui_label_8, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_8, lv_color_hex(0xffffff), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_8, &g_test_font0_12, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_8, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_8, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_8, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_8, LV_TEXT_ALIGN_RIGHT, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_8, lv_color_hex(0x14191e), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_8, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_8, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_8, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	

}
void ui_screen_3_screen_init()
{
	g_ui_screen_3 = lv_obj_create(NULL);
	lv_obj_set_style_bg_color(g_ui_screen_3, lv_color_hex(0x000000), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_screen_3, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_screen_3, lv_color_hex(0x654321), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_screen_3, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);

	es_ui_set_gif(&g_ui_gif_1, 0, 0, 0, 1, g_ui_screen_3);	
	g_ui_imgbutton_2 = lv_imgbtn_create(g_ui_screen_3);
	lv_imgbtn_set_src(g_ui_imgbutton_2, LV_IMGBTN_STATE_PRESSED, NULL, &g_test_img1, NULL);
	lv_imgbtn_set_src(g_ui_imgbutton_2, LV_IMGBTN_STATE_RELEASED, NULL, &g_test_img2, NULL);
	lv_obj_set_width(g_ui_imgbutton_2, 80);
	lv_obj_set_height(g_ui_imgbutton_2, 80);
	lv_obj_set_x(g_ui_imgbutton_2, 6);
	lv_obj_set_y(g_ui_imgbutton_2, 147);
	
	g_ui_button_9 = lv_btn_create(g_ui_screen_3);
	lv_obj_set_width(g_ui_button_9, 80);
	lv_obj_set_height(g_ui_button_9, 60);
	lv_obj_set_x(g_ui_button_9, 126);
	lv_obj_set_y(g_ui_button_9, 158);
	lv_obj_set_style_bg_color(g_ui_button_9, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_9, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_9, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_9, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_9, lv_color_hex(0x01a2b1), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_9, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_9, 2, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_9, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_9, 30, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	lv_obj_add_event_cb(g_ui_button_9, ui_event_button_9, LV_EVENT_ALL, NULL);
	g_ui_button_10 = lv_btn_create(g_ui_screen_3);
	lv_obj_set_width(g_ui_button_10, 80);
	lv_obj_set_height(g_ui_button_10, 60);
	lv_obj_set_x(g_ui_button_10, 229);
	lv_obj_set_y(g_ui_button_10, 157);
	lv_obj_set_style_bg_color(g_ui_button_10, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_button_10, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_button_10, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_button_10, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_color(g_ui_button_10, lv_color_hex(0x01a2b1), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_opa(g_ui_button_10, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_width(g_ui_button_10, 2, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_border_side(g_ui_button_10, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_radius(g_ui_button_10, 30, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	lv_obj_add_event_cb(g_ui_button_10, ui_event_button_10, LV_EVENT_ALL, NULL);
	g_ui_label_9 = lv_label_create(g_ui_screen_3);
	lv_obj_set_width(g_ui_label_9, 100);
	lv_obj_set_height(g_ui_label_9, 40);
	lv_obj_set_x(g_ui_label_9, 117);
	lv_obj_set_y(g_ui_label_9, 173);
	lv_label_set_text(g_ui_label_9, "隐藏GIF");
	lv_label_set_long_mode(g_ui_label_9, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_9, lv_color_hex(0x000000), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_9, &g_test_font0_20, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_9, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_9, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_9, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_9, LV_TEXT_ALIGN_CENTER, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_9, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_9, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_9, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_9, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	
	g_ui_label_10 = lv_label_create(g_ui_screen_3);
	lv_obj_set_width(g_ui_label_10, 80);
	lv_obj_set_height(g_ui_label_10, 40);
	lv_obj_set_x(g_ui_label_10, 227);
	lv_obj_set_y(g_ui_label_10, 169);
	lv_label_set_text(g_ui_label_10, "返回");
	lv_label_set_long_mode(g_ui_label_10, LV_LABEL_LONG_SCROLL_CIRCULAR);
	lv_obj_set_style_text_color(g_ui_label_10, lv_color_hex(0x000000), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_font(g_ui_label_10, &g_test_font0_24, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_opa(g_ui_label_10, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_letter_space(g_ui_label_10, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_line_space(g_ui_label_10, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_text_align(g_ui_label_10, LV_TEXT_ALIGN_CENTER, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_color(g_ui_label_10, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_opa(g_ui_label_10, 0, LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_color(g_ui_label_10, lv_color_hex(0x2a75e7), LV_PART_MAIN | LV_STATE_DEFAULT);
	lv_obj_set_style_bg_grad_dir(g_ui_label_10, LV_GRAD_DIR_NONE, LV_PART_MAIN | LV_STATE_DEFAULT);
	

}
void ui_init(void)
{
	ui_screen_1_screen_init();
	ui_screen_2_screen_init();
	ui_screen_3_screen_init();
	lv_disp_load_scr(g_ui_screen_1);
}


/***************** (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/

