/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    
 * @author  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "lvgl.h"

/* USER CODE BEGIN Includes */
#include "lvgl.h"
/* USER CODE END Includes */

/* Private Macros ------------------------------------------------------------ */
/* USER CODE BEGIN Private Macros */
#define _UI_TEMPORARY_STRING_BUFFER_SIZE 32
/* USER CODE END Private Macros */

/* Private Variables --------------------------------------------------------- */
/* USER CODE BEGIN Private Variables */

/* USER CODE END Private Variables */

/* Public Variables ---------------------------------------------------------- */


/* USER CODE BEGIN Public Variables */

/* USER CODE END Public Variables */

/* Private Constants --------------------------------------------------------- */

/* USER CODE BEGIN Private Constants */

/* USER CODE END Private Constants */

/* Private function prototypes ----------------------------------------------- */
void init_cmu(void);
void init_mcu(void);
void init_gpio(void);
void init_pis(void);
void init_dma(void);
void init_cuart1(void);
void init_spi0(void);
void init_spi1(void);


/* USER CODE BEGIN Private function prototypes */

/* USER CODE END Private function prototypes */

/* Private Function ---------------------------------------------------------- */

/* USER CODE BEGIN Private Function */

void _ui_arc_set_text_value(lv_obj_t *trg, lv_obj_t *src, const char *prefix, const char *postfix)
{
    char buf[_UI_TEMPORARY_STRING_BUFFER_SIZE];
    lv_snprintf(buf, sizeof(buf), "%s%d%s", prefix, (int)lv_arc_get_value(src), postfix);
    lv_label_set_text(trg, buf);
}

void user_ui_event_arc1(lv_event_t *e)
{
    lv_event_code_t event_code = lv_event_get_code(e);
    lv_obj_t *target = lv_event_get_target(e);

    if (event_code == LV_EVENT_VALUE_CHANGED)
    {
        extern lv_obj_t *g_ui_label_2;
        _ui_arc_set_text_value(g_ui_label_2, target, "", "°");
    }
}

void user_ui_events_init(void)
{
    extern lv_obj_t *g_ui_arc_2;
    lv_obj_add_event_cb(g_ui_arc_2, user_ui_event_arc1, LV_EVENT_ALL, NULL);
}

/* USER CODE END Private Function */

/**
  * @brief  Initializate cmu function
  * @param  None
  * @retval None
  */
void init_cmu(void)
{    
    /* USER CODE BEGIN init_cmu 0 */

    /* USER CODE END init_cmu 0 */
    
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC4M,MD_CMU_PLL_OUTPUT_64M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL,64000000);
    MD_SYSCFG_UNLOCK();
    md_cmu_disable_hosc_stp_interrupt();
    md_cmu_disable_hosc_safe();
    MD_SYSCFG_LOCK();

    MD_SYSCFG_UNLOCK();
    md_cmu_set_hosc_freq_region(2);
    MD_SYSCFG_LOCK();

    MD_SYSCFG_UNLOCK();
    md_cmu_disable_pll_unlock_interrupt();
    md_cmu_disable_pll_unlock_manage();
    MD_SYSCFG_LOCK();


    /* Enable all peripherals */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    /* set the clock divider */
    MD_SYSCFG_UNLOCK();
    md_cmu_div_config(MD_CMU_SYS,MD_CMU_DIV_1);
    MD_SYSCFG_LOCK();

    MD_SYSCFG_UNLOCK();
    md_cmu_div_config(MD_CMU_PCLK,MD_CMU_DIV_1);
    MD_SYSCFG_LOCK();


    /* USER CODE BEGIN init_cmu 1 */

    /* USER CODE END init_cmu 1 */
    
}
/**
  * @brief  Initializate mcu function
  * @param  None
  * @retval None
  */
void init_mcu(void)
{
    /* USER CODE BEGIN init_mcu 0 */

    /* USER CODE END init_mcu 0 */
    
    /* Enable interrupt */
    md_init_1ms_tick();

    md_mcu_irq_config(CLINT_IRQn,0,ENABLE);
    md_mcu_irq_config(EXTI0_3_IRQn,0,ENABLE);
    
    /* Enable global interrupt */
    __enable_irq();
    /* USER CODE BEGIN init_mcu 1 */

    /* USER CODE END init_mcu 1 */
    
}
/**
  * @brief  Initializate gpio function
  * @param  None
  * @retval None
  */
void init_gpio(void)
{
    /* USER CODE BEGIN init_gpio 0 */

    /* USER CODE END init_gpio 0 */
    
    md_gpio_init_t gpio_init;
    /* Initialize PA2 CUART1_TX */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA,MD_GPIO_PIN_2,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_2);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_2);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_2);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_2);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_2);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_2);
    /* Initialize PA3 CUART1_RX */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_INPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_PUSH_UP;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA,MD_GPIO_PIN_3,&gpio_init);

    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_3);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_3);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_3);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_3);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_3);
    /* Initialize PA4 PA4 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOA,MD_GPIO_PIN_4,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_4);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_4);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_4);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_4);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_4);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_4);
    /* Initialize PA5 SPI0_SCK_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA,MD_GPIO_PIN_5,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_5);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_5);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_5);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_5);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_5);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_5);
    /* Initialize PA6 SPI0_MISO_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_INPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_PUSH_UP;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA,MD_GPIO_PIN_6,&gpio_init);

    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_6);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_6);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_6);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_6);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_6);
    /* Initialize PA7 SPI0_MOSI_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA,MD_GPIO_PIN_7,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_7);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_7);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_7);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_7);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_7);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_7);
    /* Initialize PC5 PC5 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOC,MD_GPIO_PIN_5,&gpio_init);

    md_gpio_set_pin_low(GPIOC,MD_GPIO_PIN_5);
    md_gpio_set_interrupt_port(GPIOC,MD_GPIO_PIN_5);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_5);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_5);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_5);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_5);
    /* Initialize PB1 PB1 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_INPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_1,&gpio_init);

    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_1);
    md_gpio_enable_trailing_edge_trigger(MD_GPIO_PIN_1);
    md_gpio_disable_riging_edge_trigger(MD_GPIO_PIN_1);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_1);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_enable_external_interrupt(MD_GPIO_PIN_1);
    /* Initialize PB10 PB10 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd                           = MD_GPIO_PUSH_UP;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_10,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_10);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_10);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_10);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_10);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_10);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_10);
    /* Initialize PB11 PB11 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_OPEN_DRAIN;
    gpio_init.pupd                           = MD_GPIO_PUSH_UP;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_11,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_11);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_11);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_11);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_11);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_11);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_11);
    /* Initialize PB13 SPI1_SCK_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOB,MD_GPIO_PIN_13,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_13);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_13);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_13);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_13);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_13);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_13);
    /* Initialize PB15 SPI1_MOSI_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOB,MD_GPIO_PIN_15,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_15);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_15);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_15);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_15);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_15);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_15);
    /* Initialize PC8 PC8 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOC,MD_GPIO_PIN_8,&gpio_init);

    md_gpio_set_pin_low(GPIOC,MD_GPIO_PIN_8);
    md_gpio_set_interrupt_port(GPIOC,MD_GPIO_PIN_8);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_8);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_8);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_8);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_8);
    /* Initialize PC9 PC9 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOC,MD_GPIO_PIN_9,&gpio_init);

    md_gpio_set_pin_low(GPIOC,MD_GPIO_PIN_9);
    md_gpio_set_interrupt_port(GPIOC,MD_GPIO_PIN_9);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_9);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_9);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_9);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_9);
    /* Initialize PA9 PA9 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOA,MD_GPIO_PIN_9,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_9);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_9);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_9);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_9);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_9);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_9);
    /* Initialize PA10 PA10 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOA,MD_GPIO_PIN_10,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_10);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_10);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_10);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_10);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_10);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_10);
    /* USER CODE BEGIN init_gpio 1 */

    /* USER CODE END init_gpio 1 */
    
}
/**
  * @brief  Initializate pis function
  * @param  None
  * @retval None
  */
void init_pis(void)
{    
    /* USER CODE BEGIN init_pis 0 */

    /* USER CODE END init_pis 0 */
    
    md_pis_init_t pis_init;
    /* Initialize pis */
    memset(&pis_init, 0, sizeof(md_pis_init_t));

    /* USER CODE BEGIN init_pis 1 */

    /* USER CODE END init_pis 1 */
    
}
/**
  * @brief  Initializate dma function
  * @param  None
  * @retval None
  */
void init_dma(void)
{    
    /* USER CODE BEGIN init_dma 0 */

    /* USER CODE END init_dma 0 */
    
    md_dma_config_t dma_init;
    /* Initialize dma */
    memset(&dma_init, 0x0, sizeof(md_dma_config_t));

    dma_init.src                            = NULL;
    dma_init.dst                            = NULL;
    dma_init.size                           = 0;
    dma_init.src_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.dst_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.src_inc                        = DISABLE;
    dma_init.dst_inc                        = DISABLE;
    dma_init.R_power                        = MD_DMA_R_POWER_1;
    dma_init.priority                       = MD_DMA_LOW_PRIORITY;
    dma_init.mem_to_mem                     = DISABLE;
    dma_init.circle_mode                    = DISABLE;
    dma_init.msel                           = MD_DMA_MSEL_SPI0;
    dma_init.msigsel                        = MD_DMA_MSIGSEL_SPI_TXEMPTY;
    md_dma_init(MD_DMA_CH_4,&dma_init);

    dma_init.src                            = NULL;
    dma_init.dst                            = NULL;
    dma_init.size                           = 0;
    dma_init.src_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.dst_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.src_inc                        = DISABLE;
    dma_init.dst_inc                        = DISABLE;
    dma_init.R_power                        = MD_DMA_R_POWER_1;
    dma_init.priority                       = MD_DMA_LOW_PRIORITY;
    dma_init.mem_to_mem                     = DISABLE;
    dma_init.circle_mode                    = DISABLE;
    dma_init.msel                           = MD_DMA_MSEL_SPI1;
    dma_init.msigsel                        = MD_DMA_MSIGSEL_SPI_TXEMPTY;
    md_dma_init(MD_DMA_CH_5,&dma_init);

    /* USER CODE BEGIN init_dma 1 */

    /* USER CODE END init_dma 1 */
    
}
/**
  * @brief  Initializate cuart1 function
  * @param  None
  * @retval None
  */
void init_cuart1(void)
{    
    /* USER CODE BEGIN init_cuart1 0 */

    /* USER CODE END init_cuart1 0 */
    
    md_uart_init_t cuart1_init;
    md_uart_init_struct(&cuart1_init);
    /* Initialize cuart1 */
    cuart1_init.baud                           = 115200;
    cuart1_init.word_length                    = MD_UART_WORD_LENGTH_8B;
    cuart1_init.stop_bits                      = MD_UART_STOP_BITS_1;
    cuart1_init.parity                         = MD_UART_PARITY_NONE;
    cuart1_init.fctl                           = MD_UART_FLOW_CTL_DISABLE;
    cuart1_init.mode                           = MD_UART_MODE;
    md_uart_init(CUART1,&cuart1_init);

    
    /* USER CODE BEGIN init_cuart1 1 */

    /* USER CODE END init_cuart1 1 */
    
}
/**
  * @brief  Initializate spi0 function
  * @param  None
  * @retval None
  */
void init_spi0(void)
{    
    /* USER CODE BEGIN init_spi0 0 */

    /* USER CODE END init_spi0 0 */
    
    md_spi_init_t spi0_init;
    md_spi_struct_init(&spi0_init);
    /* Initialize spi0 */
    spi0_init.SPIx                           = SPI0;
    spi0_init.mode                           = MD_SPI_MODE_MASTER;
    spi0_init.dir                            = MD_SPI_DIRECTION_2LINES;
    spi0_init.data_size                      = MD_SPI_DATA_SIZE_8;
    spi0_init.baud                           = MD_SPI_BAUD_2;
    spi0_init.phase                          = MD_SPI_CPHA_SECOND;
    spi0_init.polarity                       = MD_SPI_CPOL_HIGH;
    spi0_init.first_bit                      = MD_SPI_FIRSTBIT_MSB;
    spi0_init.ss_en                          = DISABLE;
    spi0_init.crc_calc                       = DISABLE;
    spi0_init.frame                          = MD_SPI_FRAME_MOTOROLA;
    spi0_init.crc_poly                       = 7;
    md_spi_init(&spi0_init);

    
    /* USER CODE BEGIN init_spi0 1 */

    /* USER CODE END init_spi0 1 */
    
}
/**
  * @brief  Initializate spi1 function
  * @param  None
  * @retval None
  */
void init_spi1(void)
{    
    /* USER CODE BEGIN init_spi1 0 */

    /* USER CODE END init_spi1 0 */
    
    md_spi_init_t spi1_init;
    md_spi_struct_init(&spi1_init);
    /* Initialize spi1 */
    spi1_init.SPIx                           = SPI1;
    spi1_init.mode                           = MD_SPI_MODE_MASTER;
    spi1_init.dir                            = MD_SPI_DIRECTION_2LINES;
    spi1_init.data_size                      = MD_SPI_DATA_SIZE_8;
    spi1_init.baud                           = MD_SPI_BAUD_2;
    spi1_init.phase                          = MD_SPI_CPHA_SECOND;
    spi1_init.polarity                       = MD_SPI_CPOL_HIGH;
    spi1_init.first_bit                      = MD_SPI_FIRSTBIT_MSB;
    spi1_init.ss_en                          = DISABLE;
    spi1_init.crc_calc                       = DISABLE;
    spi1_init.frame                          = MD_SPI_FRAME_MOTOROLA;
    spi1_init.crc_poly                       = 7;
    md_spi_init(&spi1_init);

    
    /* USER CODE BEGIN init_spi1 1 */

    /* USER CODE END init_spi1 1 */
    
}
/**
  * @brief  Main function
  * @retval Status.
 */
int main(void)
{
    /* USER CODE BEGIN 1 */

    /* USER CODE END 1 */
    
    __disable_irq();
    /* Initialize cmu */
    init_cmu();

    /* Initialize mcu */
    init_mcu();

    /* Initialize gpio */
    init_gpio();

    /* Initialize pis */
    init_pis();

    /* Initialize dma */
    init_dma();

    /* Initialize cuart1 */
    init_cuart1();

    /* Initialize spi0 */
    init_spi0();

    /* Initialize spi1 */
    init_spi1();

    __enable_irq();


    /* Initialize mid gui */
    gui_main_init();

    /* USER CODE BEGIN 2 */
    user_ui_events_init();
    /* USER CODE END 2 */
    
    while (1)
    {
        /* handle mid gui */
        gui_main_loop();

        /* USER CODE BEGIN 3 */
        
        /* USER CODE END 3 */
        
    }
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  printf _write function
  * @retval len
  */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        cnt = 4000;

        while ((READ_BIT(CUART1->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK
                && (--cnt))
        {
        }

        WRITE_REG(CUART1->TXBUF, *ptr_char++);
    }

    return len;
}


/* USER CODE BEGIN 5 */

/* USER CODE END 5 */


/**
  * @}
  */
/**
  * @}
  */
/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
