/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "es_st7789.h"

/* Private Macros ------------------------------------------------------------ */
/* ST7789 specific commands used in init*/
#define ST7789_NOP          0x00
#define ST7789_SWRESET      0x01
#define ST7789_RDDID        0x04
#define ST7789_RDDST        0x09

#define ST7789_RDDPM        0x0A      /*Read display power mode*/
#define ST7789_RDD_MADCTL   0x0B      /*Read display MADCTL*/
#define ST7789_RDD_COLMOD   0x0C      /*Read display pixel format*/
#define ST7789_RDDIM        0x0D      /*Read display image mode*/
#define ST7789_RDDSM        0x0E      /*Read display signal mode*/
#define ST7789_RDDSR        0x0F      /*Read display self-diagnostic result (ST7789V)*/

#define ST7789_SLPIN        0x10
#define ST7789_SLPOUT       0x11
#define ST7789_PTLON        0x12
#define ST7789_NORON        0x13

#define ST7789_INVOFF       0x20
#define ST7789_INVON        0x21
#define ST7789_GAMSET       0x26      /*Gamma set*/
#define ST7789_DISPOFF      0x28
#define ST7789_DISPON       0x29
#define ST7789_CASET        0x2A
#define ST7789_RASET        0x2B
#define ST7789_RAMWR        0x2C
#define ST7789_RGBSET       0x2D      /*Color setting for 4096, 64K and 262K colors*/
#define ST7789_RAMRD        0x2E

#define ST7789_PTLAR        0x30
#define ST7789_VSCRDEF      0x33      /*Vertical scrolling definition (ST7789V)*/
#define ST7789_TEOFF        0x34      /*Tearing effect line off*/
#define ST7789_TEON         0x35      /*Tearing effect line on*/
#define ST7789_MADCTL       0x36      /*Memory data access control*/
#define ST7789_IDMOFF       0x38      /*Idle mode off*/
#define ST7789_IDMON        0x39      /*Idle mode on*/
#define ST7789_RAMWRC       0x3C      /*Memory write continue (ST7789V)*/
#define ST7789_RAMRDC       0x3E      /*Memory read continue (ST7789V)*/
#define ST7789_COLMOD       0x3A

#define ST7789_RAMCTRL      0xB0      /*RAM control*/
#define ST7789_RGBCTRL      0xB1      /*RGB control*/
#define ST7789_PORCTRL      0xB2      /*Porch control*/
#define ST7789_FRCTRL1      0xB3      /*Frame rate control*/
#define ST7789_PARCTRL      0xB5      /*Partial mode control*/
#define ST7789_GCTRL        0xB7      /*Gate control*/
#define ST7789_GTADJ        0xB8      /*Gate on timing adjustment*/
#define ST7789_DGMEN        0xBA      /*Digital gamma enable*/
#define ST7789_VCOMS        0xBB      /*VCOMS setting*/
#define ST7789_LCMCTRL      0xC0      /*LCM control*/
#define ST7789_IDSET        0xC1      /*ID setting*/
#define ST7789_VDVVRHEN     0xC2      /*VDV and VRH command enable*/
#define ST7789_VRHS         0xC3      /*VRH set*/
#define ST7789_VDVSET       0xC4      /*VDV setting*/
#define ST7789_VCMOFSET     0xC5      /*VCOMS offset set*/
#define ST7789_FRCTR2       0xC6      /*FR Control 2*/
#define ST7789_CABCCTRL     0xC7      /*CABC control*/
#define ST7789_REGSEL1      0xC8      /*Register value section 1*/
#define ST7789_REGSEL2      0xCA      /*Register value section 2*/
#define ST7789_PWMFRSEL     0xCC      /*PWM frequency selection*/
#define ST7789_PWCTRL1      0xD0      /*Power control 1*/
#define ST7789_VAPVANEN     0xD2      /*Enable VAP/VAN signal output*/
#define ST7789_CMD2EN       0xDF      /*Command 2 enable*/
#define ST7789_PVGAMCTRL    0xE0      /*Positive voltage gamma control*/
#define ST7789_NVGAMCTRL    0xE1      /*Negative voltage gamma control*/
#define ST7789_DGMLUTR      0xE2      /*Digital gamma look-up table for red*/
#define ST7789_DGMLUTB      0xE3      /*Digital gamma look-up table for blue*/
#define ST7789_GATECTRL     0xE4      /*Gate control*/
#define ST7789_SPI2EN       0xE7      /*SPI2 enable*/
#define ST7789_PWCTRL2      0xE8      /*Power control 2*/
#define ST7789_EQCTRL       0xE9      /*Equalize time control*/
#define ST7789_PROMCTRL     0xEC      /*Program control*/
#define ST7789_PROMEN       0xFA      /*Program mode enable*/
#define ST7789_NVMSET       0xFC      /*NVM setting*/
#define ST7789_PROMACT      0xFE      /*Program action*/

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

void es_st7789_lcd_write_area_cmd(uint16_t x1, uint16_t x2, uint16_t y1, uint16_t y2)
{
	
#if ES_USE_LCD_AREA_OFFSET
#if ES_LCD_X2Y
#if ES_LCD_X_ORDER
#if ES_LCD_Y_ORDER
		x1 += ES_USE_LCD_AREA_OFFSET_Y;    
		x2 += ES_USE_LCD_AREA_OFFSET_Y;
#else
         
#endif /*ES_LCD_Y_ORDER*/
#else
#if ES_LCD_Y_ORDER
        x1 += ES_USE_LCD_AREA_OFFSET_Y;    
		x2 += ES_USE_LCD_AREA_OFFSET_Y;
#else
        
#endif /*ES_LCD_Y_ORDER*/
#endif /*ES_LCD_X_ORDER*/
#else
#if ES_LCD_X_ORDER
#if ES_LCD_Y_ORDER
		y1 += ES_USE_LCD_AREA_OFFSET_Y;    
		y2 += ES_USE_LCD_AREA_OFFSET_Y;
#else
        
#endif /*ES_LCD_Y_ORDER*/
#else
#if ES_LCD_Y_ORDER
		y1 += ES_USE_LCD_AREA_OFFSET_Y;    
		y2 += ES_USE_LCD_AREA_OFFSET_Y;
#else
	
#endif /*ES_LCD_Y_ORDER*/
#endif /*ES_LCD_X_ORDER*/
#endif /*ES_LCD_X2Y*/
#endif /*ES_USE_LCD_AREA_OFFSET*/
	
    es_st7789_port_lcd_wrte_cmd(0x2A);
    es_st7789_port_lcd_wrte_data(x1 >> 8);
    es_st7789_port_lcd_wrte_data(x1 & 0xFF);
    es_st7789_port_lcd_wrte_data(x2 >> 8);
    es_st7789_port_lcd_wrte_data(x2 & 0xFF);

    es_st7789_port_lcd_wrte_cmd(0x2B);
    es_st7789_port_lcd_wrte_data(y1 >> 8);
    es_st7789_port_lcd_wrte_data(y1 & 0xFF);
    es_st7789_port_lcd_wrte_data(y2 >> 8);
    es_st7789_port_lcd_wrte_data(y2 & 0xFF);
    es_st7789_port_lcd_wrte_cmd(0x2C);
}

void es_st7789_lcd_init(void)
{
    /*------------------------------------ST7735R Reset Sequence-----------------------------------------*/
    md_gpio_set_pin_high(ES_LCD_RST_PIN_PORT, ES_LCD_RST_PIN_MD_PIN);
    ES_DELAY_MS(100);
    md_gpio_set_pin_low(ES_LCD_RST_PIN_PORT, ES_LCD_RST_PIN_MD_PIN);
    ES_DELAY_MS(200);
    md_gpio_set_pin_high(ES_LCD_RST_PIN_PORT, ES_LCD_RST_PIN_MD_PIN);
    ES_DELAY_MS(500);
    /*---------------------------------------------------------------------------------------------------*/
    es_st7789_port_lcd_wrte_cmd(ST7789_SLPOUT);   /* Sleep out */
    ES_DELAY_MS(120);

    es_st7789_port_lcd_wrte_cmd(ST7789_NORON);    /* Normal display mode on */

    /*------------------------------display and color format setting--------------------------------*/
    es_st7789_port_lcd_wrte_cmd(ST7789_MADCTL);
    es_st7789_port_lcd_wrte_data(ES_LCD_X2Y | ES_LCD_X_ORDER | ES_LCD_Y_ORDER);

    /* JLX240 display datasheet */
    es_st7789_port_lcd_wrte_cmd(0xB6);
    es_st7789_port_lcd_wrte_data(0x0A);
    es_st7789_port_lcd_wrte_data(0x82);

    es_st7789_port_lcd_wrte_cmd(ST7789_RAMCTRL);
    es_st7789_port_lcd_wrte_data(0x00);
    es_st7789_port_lcd_wrte_data(0xE0); /* 5 to 6 bit conversion: r0 = r5, b0 = b5*/

    es_st7789_port_lcd_wrte_cmd(ST7789_COLMOD);
    es_st7789_port_lcd_wrte_data(0x55);
    ES_DELAY_MS(10);

    /*--------------------------------ST7789V Frame rate setting----------------------------------*/
    es_st7789_port_lcd_wrte_cmd(ST7789_PORCTRL);
    es_st7789_port_lcd_wrte_data(0x0c);
    es_st7789_port_lcd_wrte_data(0x0c);
    es_st7789_port_lcd_wrte_data(0x00);
    es_st7789_port_lcd_wrte_data(0x33);
    es_st7789_port_lcd_wrte_data(0x33);

    es_st7789_port_lcd_wrte_cmd(ST7789_GCTRL);      /* Voltages: VGH / VGL*/
    es_st7789_port_lcd_wrte_data(0x35);

    /*---------------------------------ST7789V Power setting--------------------------------------*/
    es_st7789_port_lcd_wrte_cmd(ST7789_VCOMS);
    es_st7789_port_lcd_wrte_data(0x28);       /* JLX240 display datasheet*/

    es_st7789_port_lcd_wrte_cmd(ST7789_LCMCTRL);
    es_st7789_port_lcd_wrte_data(0x2C);

    es_st7789_port_lcd_wrte_cmd(ST7789_VDVVRHEN);
    es_st7789_port_lcd_wrte_data(0x01);
    es_st7789_port_lcd_wrte_data(0xFF);

    es_st7789_port_lcd_wrte_cmd(ST7789_VRHS);       /* voltage VRHS*/
    es_st7789_port_lcd_wrte_data(0x10);

    es_st7789_port_lcd_wrte_cmd(ST7789_VDVSET);
    es_st7789_port_lcd_wrte_data(0x20);

    es_st7789_port_lcd_wrte_cmd(ST7789_FRCTR2);
    es_st7789_port_lcd_wrte_data(0x0f);

    es_st7789_port_lcd_wrte_cmd(ST7789_PWCTRL1);
    es_st7789_port_lcd_wrte_data(0xa4);
    es_st7789_port_lcd_wrte_data(0xa1);

    /*--------------------------------ST7789V gamma setting---------------------------------------*/
    es_st7789_port_lcd_wrte_cmd(ST7789_PVGAMCTRL);
    es_st7789_port_lcd_wrte_data(0xd0);
    es_st7789_port_lcd_wrte_data(0x00);
    es_st7789_port_lcd_wrte_data(0x02);
    es_st7789_port_lcd_wrte_data(0x07);
    es_st7789_port_lcd_wrte_data(0x0a);
    es_st7789_port_lcd_wrte_data(0x28);
    es_st7789_port_lcd_wrte_data(0x32);
    es_st7789_port_lcd_wrte_data(0x44);
    es_st7789_port_lcd_wrte_data(0x42);
    es_st7789_port_lcd_wrte_data(0x06);
    es_st7789_port_lcd_wrte_data(0x0e);
    es_st7789_port_lcd_wrte_data(0x12);
    es_st7789_port_lcd_wrte_data(0x14);
    es_st7789_port_lcd_wrte_data(0x17);

    es_st7789_port_lcd_wrte_cmd(ST7789_NVGAMCTRL);
    es_st7789_port_lcd_wrte_data(0xd0);
    es_st7789_port_lcd_wrte_data(0x00);
    es_st7789_port_lcd_wrte_data(0x02);
    es_st7789_port_lcd_wrte_data(0x07);
    es_st7789_port_lcd_wrte_data(0x0a);
    es_st7789_port_lcd_wrte_data(0x28);
    es_st7789_port_lcd_wrte_data(0x31);
    es_st7789_port_lcd_wrte_data(0x54);
    es_st7789_port_lcd_wrte_data(0x47);
    es_st7789_port_lcd_wrte_data(0x0e);
    es_st7789_port_lcd_wrte_data(0x1c);
    es_st7789_port_lcd_wrte_data(0x17);
    es_st7789_port_lcd_wrte_data(0x1b);
    es_st7789_port_lcd_wrte_data(0x1e);

    es_st7789_port_lcd_wrte_cmd(ST7789_INVON);

    es_st7789_port_lcd_wrte_cmd(ST7789_DISPON);    /* Display on */
    ES_DELAY_MS(120);
}
