/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "es_mid_gui_conf.h"
#include "es_gt91x.h"
#include "es_st7789.h"
#include "stdio.h"
#include "printf.h"
#include "ui.h"
#include "es_spi_flash.h"
#include "lv_draw_sw.h"

/* Private Macros ------------------------------------------------------------ */
#define printf printf_/*Reduce ROM usage*/

/* Private Variables --------------------------------------------------------- */
static lv_disp_draw_buf_t s_draw_buf_dsc;
static lv_color_t s_draw_buf_1[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*A buffer for n rows*/
#if (ES_LVGL_USE_2_DISP_BUF)
    static lv_color_t s_draw_buf_2[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*An other buffer for n rows*/
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/

static lv_coord_t s_indev_x = 0;
static lv_coord_t s_indev_y = 0;
static lv_indev_state_t s_indev_state = LV_INDEV_STATE_RELEASED;
//#include "lv_draw_sw.h"
//#include "lv_draw_sw_blend.h"
/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */


extern lv_indev_t g_es_indev_act;
extern uint32_t g_es_anim_last_timer_run;
extern uint8_t g_es_anim_timer_pause;

extern void es_anim_timer_handle(void);

extern const es_gif_info_t *g_es_gui_gifs_addr_table[];
extern const uint32_t g_es_gui_gifs_addr_table_num;

volatile uint8_t g_es_user_change_gif_conf_flag = 0U;


uint8_t change_bg_flag = 0;
uint32_t change_bg_img_index;


extern uint32_t g_es_heap_max_used_addr;


void es_lv_touch_read(lv_indev_drv_t *s_indev_drv, lv_indev_data_t *data)
{
    data->state   = s_indev_state;
    data->point.x = s_indev_x;
    data->point.y = s_indev_y;
}

void es_lvgl_gt91x_touch_read(void)
{
    uint8_t touch_state;
    struct es_touch_data touch_data;

    touch_state = gt911_touch_scan(&touch_data, 1);

    if (touch_state)
    {
        s_indev_state = LV_INDEV_STATE_PR;
        s_indev_x = touch_data.x_coordinate;
        s_indev_y = touch_data.y_coordinate;
    }
    else
    {
        s_indev_state = LV_INDEV_STATE_REL;
    }
}

void es_lv_wait_flushing(void)
{

}

void es_lv_disable_irq(void)
{

}

void es_lv_enable_irq(void)
{

}

extern lv_disp_t g_es_disp_def;
extern lv_indev_t g_es_indev_act;

void es_lvgl_init(void)
{

#if LV_USE_LOG
#warning "need lv_log_register_print_cb()"
#endif /* LV_USE_LOG */
    lv_init();


    lv_memset_00(&g_es_disp_def, sizeof(lv_disp_t));

    s_draw_buf_dsc.buf1    = s_draw_buf_1;
#if (ES_LVGL_USE_2_DISP_BUF)
    s_draw_buf_dsc.buf2    = s_draw_buf_2;
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/
    s_draw_buf_dsc.buf_act = s_draw_buf_dsc.buf1;
    s_draw_buf_dsc.size    = ES_LVGL_EACH_COLOR_DISP_BUF_SIZE;

    g_es_disp_def.driver.screen_transp    = 0;
    g_es_disp_def.driver.dpi              = LV_DPI_DEF;
    g_es_disp_def.driver.color_chroma_key = LV_COLOR_CHROMA_KEY;

    g_es_disp_def.driver.draw_ctx_size = sizeof(lv_draw_sw_ctx_t);

    /*Set the resolution of the display*/
    g_es_disp_def.driver.hor_res = ES_LVGL_LCD_DISP_HOR_RES;
    g_es_disp_def.driver.ver_res = ES_LVGL_LCD_DISP_VER_RES;

    /*Set a display buffer*/
    g_es_disp_def.driver.draw_buf = &s_draw_buf_dsc;


#ifdef ES_LV_CONF_OPTIMIZE_USE_BG_OPA
#if LV_COLOR_SCREEN_TRANSP
    g_es_disp_def.bg_opa = LV_OPA_TRANSP;
#else
    g_es_disp_def.bg_opa = LV_OPA_COVER;
#endif
#endif

    g_es_disp_def.act_scr   = lv_obj_create(NULL); /*Create a default screen on the display*/
    g_es_disp_def.top_layer = lv_obj_create(NULL); /*Create top layer on the display*/
    g_es_disp_def.sys_layer = lv_obj_create(NULL); /*Create sys layer on the display*/
    lv_obj_remove_style_all(g_es_disp_def.top_layer);
    lv_obj_remove_style_all(g_es_disp_def.sys_layer);
    lv_obj_clear_flag(g_es_disp_def.top_layer, LV_OBJ_FLAG_CLICKABLE);
    lv_obj_clear_flag(g_es_disp_def.sys_layer, LV_OBJ_FLAG_CLICKABLE);

    lv_obj_set_scrollbar_mode(g_es_disp_def.top_layer, LV_SCROLLBAR_MODE_OFF);
    lv_obj_set_scrollbar_mode(g_es_disp_def.sys_layer, LV_SCROLLBAR_MODE_OFF);

    lv_obj_invalidate(g_es_disp_def.act_scr);

    g_es_disp_def.refr_timer_last_run = lv_tick_get();
    g_es_disp_def.refr_timer_pause = 1;

    g_es_indev_act.driver.scroll_limit         = LV_INDEV_DEF_SCROLL_LIMIT;
    g_es_indev_act.driver.scroll_throw         = LV_INDEV_DEF_SCROLL_THROW;
    g_es_indev_act.driver.long_press_time      = LV_INDEV_DEF_LONG_PRESS_TIME;
    g_es_indev_act.driver.long_press_repeat_time  = LV_INDEV_DEF_LONG_PRESS_REP_TIME;
    g_es_indev_act.driver.gesture_limit        = LV_INDEV_DEF_GESTURE_LIMIT;
    g_es_indev_act.driver.gesture_min_velocity = LV_INDEV_DEF_GESTURE_MIN_VELOCITY;

    g_es_indev_act.proc.reset_query  = 1;
}

uint32_t g_stack_addr_min = 0xFFFFFFFF;

uint8_t es_push_stack_check(uint32_t size)
{
    uint32_t temp_sp = __get_SP();

    if (temp_sp < g_stack_addr_min)
    {
        g_stack_addr_min = temp_sp;
    }

    if (temp_sp < g_es_heap_max_used_addr + size + ES_RAM_STACK_HEAP_GAP_RAM_SIZE)
    {
        __disable_irq();

        while (1);/*RAM空间不足*/

        return 1;
    }

    return 0;
}

void es_lvgl_run(void)
{
    uint32_t i;
    es_gif_info_t *gif1;
    uint8_t gif_img_out_flag;

    if (!g_es_anim_timer_pause)
    {
        if (lv_tick_elaps(g_es_anim_last_timer_run) > LV_DISP_DEF_REFR_PERIOD)
        {
            es_anim_timer_handle();
        }
    }

    if (!g_es_disp_def.refr_timer_pause)
    {
        if (lv_tick_elaps(g_es_disp_def.refr_timer_last_run) > LV_DISP_DEF_REFR_PERIOD)
        {
            if (change_bg_flag)
            {
                change_bg_flag = 0;
                es_spiflash_gui_ext_mem_show_img(0, 0, change_bg_img_index);
            }

            _lv_disp_refr_timer();
        }
    }

#if ES_GUI_PRJ_CONF_USE_GIF

    for (i = 0; i < g_es_gui_gifs_addr_table_num; i++)
    {
        gif1 = (es_gif_info_t *)g_es_gui_gifs_addr_table[i];

        if (g_es_disp_def.act_scr != gif1->gif_in_screenx_addr)
        {
            continue;
        }

        if (gif1->gif_conf & ES_GIF_CONF_ENABLE)
        {
            gif_img_out_flag = 0;

            if (!(gif1->gif_state & ES_GIF_STATE_ENABLE))
            {
                gif1->gif_state |= ES_GIF_STATE_ENABLE;
                es_spiflash_gui_ext_mem_get_gif_info(gif1);
                gif1->gif_img_index = 0;
                gif_img_out_flag = 1;
            }

            if (lv_tick_elaps(gif1->gif_last_run_time) > gif1->gif_time_duration)
            {
                gif_img_out_flag = 1;
            }

            if (gif_img_out_flag)
            {
                gif_img_out_flag = 0;
                gif1->gif_last_run_time = lv_tick_get();

                es_spiflash_gui_ext_mem_show_gif_frame(gif1, gif1->gif_img_index);

                gif1->gif_img_index++;
            }

            if (gif1->gif_img_index >= gif1->gif_img_max_index)
            {
                gif1->gif_img_index = 0;
            }
        }
        else
        {
            gif1->gif_state &= ~ES_GIF_STATE_ENABLE;
        }
    }

#endif

#if ES_GUI_USE_TOUCH

    if (lv_tick_elaps(g_es_indev_act.driver.read_timer_last_run) > LV_INDEV_DEF_READ_PERIOD)
    {
        lv_indev_read_timer_cb();
    }

#endif
}
