/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    
 * @author  
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "lvgl.h"

/* USER CODE BEGIN Includes */
#include "lvgl.h"
/* USER CODE END Includes */

/* Private Macros ------------------------------------------------------------ */
/* USER CODE BEGIN Private Macros */
#define _UI_TEMPORARY_STRING_BUFFER_SIZE 32
/* USER CODE END Private Macros */

/* Private Variables --------------------------------------------------------- */
/* USER CODE BEGIN Private Variables */

/* USER CODE END Private Variables */

/* Public Variables ---------------------------------------------------------- */


/* USER CODE BEGIN Public Variables */
uint32_t g_test_key_in_screenx = 0U;
uint32_t g_test_key_in_obj_id_in_screenx = 0xFFFFFFFFU;
uint8_t g_test_key_state = 0U;
uint8_t g_test_key_level;
lv_obj_t * g_obj_show_key_select = NULL;
uint8_t g_key1_flag = 0U;
uint8_t g_key2_flag = 0U;
/* USER CODE END Public Variables */

/* Private Constants --------------------------------------------------------- */

/* USER CODE BEGIN Private Constants */

/* USER CODE END Private Constants */

/* Private function prototypes ----------------------------------------------- */
void init_cmu(void);
void init_mcu(void);
void init_gpio(void);
void init_pis(void);
void init_dma(void);
void init_spi0(void);
void init_spi1(void);
void init_cuart0(void);


/* USER CODE BEGIN Private function prototypes */

/* USER CODE END Private function prototypes */

/* Private Function ---------------------------------------------------------- */

/* USER CODE BEGIN Private Function */

void es_test_select_next_obj_in_screen()
{
    uint32_t i,cnt,find_id;
    lv_obj_t * obj;
    
    if(g_test_key_in_screenx != (uint32_t)g_es_disp_def.act_scr)
    {
        g_test_key_in_screenx = (uint32_t)g_es_disp_def.act_scr;
        g_test_key_in_obj_id_in_screenx = 0xFFFFFFFF;
        
        if(g_obj_show_key_select)
        {
            lv_obj_del(g_obj_show_key_select);
        }
            
        g_obj_show_key_select = lv_obj_create(g_es_disp_def.act_scr);
        
        
        lv_obj_set_style_border_color(g_obj_show_key_select, lv_color_hex(0xFF0000), LV_PART_MAIN | LV_STATE_DEFAULT);
        lv_obj_set_style_border_opa(g_obj_show_key_select, 255, LV_PART_MAIN | LV_STATE_DEFAULT);
        lv_obj_set_style_border_width(g_obj_show_key_select, 2, LV_PART_MAIN | LV_STATE_DEFAULT);
        lv_obj_set_style_border_side(g_obj_show_key_select, LV_BORDER_SIDE_FULL, LV_PART_MAIN | LV_STATE_DEFAULT);
        
        lv_obj_set_width(g_obj_show_key_select, 0);
        lv_obj_set_height(g_obj_show_key_select, 0);
        lv_obj_set_x(g_obj_show_key_select, 1);
        lv_obj_set_y(g_obj_show_key_select, 1);
        
        g_obj_show_key_select->layout_inv = 0;
        lv_obj_refr_size(g_obj_show_key_select);
        lv_obj_refr_pos(g_obj_show_key_select);
        
        lv_obj_invalidate(g_obj_show_key_select);
    }
    else
    {
        if(g_test_key_in_obj_id_in_screenx != 0xFFFFFFFF)
        {
            lv_obj_invalidate(g_obj_show_key_select);
        }
    }
    
    if(g_es_disp_def.act_scr->spec_attr)
    {
        if(g_es_disp_def.act_scr->spec_attr->child_cnt)
        {
            cnt = g_es_disp_def.act_scr->spec_attr->child_cnt;
            
            for(i = 1;i <= cnt;i++)
            {
                find_id = (g_test_key_in_obj_id_in_screenx + i) % cnt;
                obj = g_es_disp_def.act_scr->spec_attr->children[find_id];
                
                if(obj == g_obj_show_key_select)
                {
                    continue;
                }
                
                if (obj->class_p == (&lv_btn_class))
                {
                    if(obj->spec_attr)
                    {
                        if(obj->spec_attr->event_dsc_cnt)
                        {
                            break;
                        }
                    }
                }
                
                if (obj->class_p == (&lv_imgbtn_class))
                {
                    break;
                }
                
                if (obj->class_p == (&lv_bar_class))
                {
                    break;
                }
                
                if (obj->class_p == (&lv_slider_class))
                {
                    break;
                }
                
                if (obj->class_p == (&lv_arc_class))
                {
                    break;
                }
            }
            
            if(i <= cnt)
            {
                g_test_key_in_obj_id_in_screenx = find_id;
                
                lv_area_copy(&(g_obj_show_key_select->coords),&(obj->coords));
                lv_obj_invalidate(g_obj_show_key_select);
            }
        }
    }
}

void es_test_change_select_obj()
{
    lv_obj_t * obj;
    uint8_t event_send_flag;
    uint16_t min,max,val;
    
    if(g_test_key_in_screenx != (uint32_t)g_es_disp_def.act_scr)
    {
        g_test_key_in_obj_id_in_screenx = 0xFFFFFFFF;
    }
    
    if(g_test_key_in_obj_id_in_screenx != 0xFFFFFFFF)
    {
        if(g_es_disp_def.act_scr->spec_attr)
        {
            if(g_es_disp_def.act_scr->spec_attr->child_cnt)
            {
                if(g_test_key_in_obj_id_in_screenx < g_es_disp_def.act_scr->spec_attr->child_cnt)
                {
                    obj = g_es_disp_def.act_scr->spec_attr->children[g_test_key_in_obj_id_in_screenx];
                    
                    event_send_flag = 0;
                    
                    if (obj->class_p == (&lv_btn_class))
                    {
                        if(obj->spec_attr)
                        {
                            if(obj->spec_attr->event_dsc_cnt)
                            {
                                event_send_flag = 1;
                            }
                        }
                    }
                    
                    if (obj->class_p == (&lv_imgbtn_class))
                    {
                        event_send_flag = 1;
                    }
                    
                    if (obj->class_p == (&lv_bar_class))
                    {
                        event_send_flag = 2;
                    }
                    
                    if (obj->class_p == (&lv_slider_class))
                    {
                        event_send_flag = 2;
                    }
                    
                    if (obj->class_p == (&lv_arc_class))
                    {
                        event_send_flag = 3;
                    }
                    
                    if(event_send_flag == 1)
                    {
                        if(g_test_key_state)
                        {
                            lv_event_send(obj, LV_EVENT_PRESSED, NULL);
                        }
                        else
                        {
                            lv_event_send(obj, LV_EVENT_RELEASED, NULL);
                            lv_event_send(obj, LV_EVENT_CLICKED, NULL);
                        }
                    }
                    
                    if(event_send_flag == 2)
                    {
                        if(g_test_key_state)
                        {
                            max = lv_bar_get_max_value(obj);
                            min = lv_bar_get_min_value(obj);
                            val = lv_bar_get_value(obj);
                            
                            val++;
                            
                            if(val > max)
                            {
                                val = min;
                            }
                            
                            lv_bar_set_value(obj,val,LV_ANIM_OFF);
                            lv_event_send(obj, LV_EVENT_VALUE_CHANGED, NULL);
                        }
                    }
                    
                    if(event_send_flag == 3)
                    {
                        if(g_test_key_state)
                        {
                            max = lv_arc_get_max_value(obj);
                            min = lv_arc_get_min_value(obj);
                            val = lv_arc_get_value(obj);
                            
                            val++;
                            
                            if(val > max)
                            {
                                val = min;
                            }
                            
                            lv_arc_set_value(obj,val);
                            lv_event_send(obj, LV_EVENT_VALUE_CHANGED, NULL);
                        }
                    }
                }
            }
        }
    }
}

void _ui_arc_set_text_value(lv_obj_t *trg, lv_obj_t *src, const char *prefix, const char *postfix)
{
    char buf[_UI_TEMPORARY_STRING_BUFFER_SIZE];
    lv_snprintf(buf, sizeof(buf), "%s%d%s", prefix, (int)lv_arc_get_value(src), postfix);
    lv_label_set_text(trg, buf);
}

void user_ui_event_arc1(lv_event_t *e)
{
    lv_event_code_t event_code = lv_event_get_code(e);
    lv_obj_t *target = lv_event_get_target(e);

    if (event_code == LV_EVENT_VALUE_CHANGED)
    {
        extern lv_obj_t *g_ui_label_2;
        _ui_arc_set_text_value(g_ui_label_2, target, "", "°");
    }
}

void user_ui_events_init(void)
{
    extern lv_obj_t *g_ui_arc_2;
    lv_obj_add_event_cb(g_ui_arc_2, user_ui_event_arc1, LV_EVENT_ALL, NULL);
}

/* USER CODE END Private Function */

/**
  * @brief  Initializate cmu function
  * @param  None
  * @retval None
  */
void init_cmu(void)
{    
    /* USER CODE BEGIN init_cmu 0 */

    /* USER CODE END init_cmu 0 */
    
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC4M,MD_CMU_PLL_OUTPUT_64M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL,64000000);
    MD_SYSCFG_UNLOCK();
    md_cmu_disable_hosc_stp_interrupt();
    md_cmu_disable_hosc_safe();
    MD_SYSCFG_LOCK();

    MD_SYSCFG_UNLOCK();
    md_cmu_set_hosc_freq_region(2);
    MD_SYSCFG_LOCK();

    MD_SYSCFG_UNLOCK();
    md_cmu_disable_pll_unlock_interrupt();
    md_cmu_disable_pll_unlock_manage();
    MD_SYSCFG_LOCK();


    /* Enable all peripherals */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    /* set the clock divider */
    MD_SYSCFG_UNLOCK();
    md_cmu_div_config(MD_CMU_SYS,MD_CMU_DIV_1);
    MD_SYSCFG_LOCK();

    MD_SYSCFG_UNLOCK();
    md_cmu_div_config(MD_CMU_PCLK,MD_CMU_DIV_1);
    MD_SYSCFG_LOCK();


    /* USER CODE BEGIN init_cmu 1 */

    /* USER CODE END init_cmu 1 */
    
}
/**
  * @brief  Initializate mcu function
  * @param  None
  * @retval None
  */
void init_mcu(void)
{
    /* USER CODE BEGIN init_mcu 0 */

    /* USER CODE END init_mcu 0 */
    
    /* Enable interrupt */
    md_init_1ms_tick();

    md_mcu_irq_config(CLINT_IRQn,0,ENABLE);
    md_mcu_irq_config(EXTI0_3_IRQn,0,ENABLE);
    md_mcu_irq_config(EXTI4_7_IRQn,0,ENABLE);
    
    /* Enable global interrupt */
    __enable_irq();
    /* USER CODE BEGIN init_mcu 1 */

    /* USER CODE END init_mcu 1 */
    
}
/**
  * @brief  Initializate gpio function
  * @param  None
  * @retval None
  */
void init_gpio(void)
{
    /* USER CODE BEGIN init_gpio 0 */

    /* USER CODE END init_gpio 0 */
    
    md_gpio_init_t gpio_init;
    /* Initialize PA1 SPI0_SCK_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_4;
    md_gpio_init(GPIOA,MD_GPIO_PIN_1,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_1);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_1);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_1);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_1);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_1);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_1);
    /* Initialize PA2 SPI0_MISO_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_INPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_PUSH_UP;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_4;
    md_gpio_init(GPIOA,MD_GPIO_PIN_2,&gpio_init);

    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_2);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_2);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_2);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_2);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_2);
    /* Initialize PA3 SPI0_MOSI_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_4;
    md_gpio_init(GPIOA,MD_GPIO_PIN_3,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_3);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_3);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_3);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_3);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_3);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_3);
    /* Initialize PA4 PA4 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOA,MD_GPIO_PIN_4,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_4);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_4);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_4);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_4);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_4);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_4);
    /* Initialize PB11 PB11 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_11,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_11);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_11);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_11);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_11);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_11);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_11);
    /* Initialize PB12 PB12 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_12,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_12);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_12);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_12);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_12);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_12);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_12);
    /* Initialize PB13 SPI1_SCK_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOB,MD_GPIO_PIN_13,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_13);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_13);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_13);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_13);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_13);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_13);
    /* Initialize PB14 PB14 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_14,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_14);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_14);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_14);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_14);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_14);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_14);
    /* Initialize PB15 SPI1_MOSI_MASTER */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_STRONG;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOB,MD_GPIO_PIN_15,&gpio_init);

    md_gpio_set_pin_low(GPIOB,MD_GPIO_PIN_15);
    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_15);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_15);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_15);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_15);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_15);
    /* Initialize PA8 PA8 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOA,MD_GPIO_PIN_8,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_8);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_8);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_8);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_8);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_8);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_8);
    /* Initialize PA9 CUART0_TX */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA,MD_GPIO_PIN_9,&gpio_init);

    md_gpio_set_pin_low(GPIOA,MD_GPIO_PIN_9);
    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_9);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_9);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_9);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_9);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_9);
    /* Initialize PA10 CUART0_RX */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_INPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_PUSH_UP;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOA,MD_GPIO_PIN_10,&gpio_init);

    md_gpio_set_interrupt_port(GPIOA,MD_GPIO_PIN_10);
    md_gpio_enable_riging_edge_trigger(MD_GPIO_PIN_10);
    md_gpio_disable_trailing_edge_trigger(MD_GPIO_PIN_10);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_10);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_disable_external_interrupt(MD_GPIO_PIN_10);
    /* Initialize PB3 PB3 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_INPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_3,&gpio_init);

    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_3);
    md_gpio_enable_trailing_edge_trigger(MD_GPIO_PIN_3);
    md_gpio_disable_riging_edge_trigger(MD_GPIO_PIN_3);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_3);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_enable_external_interrupt(MD_GPIO_PIN_3);
    /* Initialize PB4 PB4 */
    md_gpio_init_struct(&gpio_init);
    gpio_init.mode                           = MD_GPIO_MODE_INPUT;
    gpio_init.odos                           = MD_GPIO_PUSH_PULL;
    gpio_init.pupd                           = MD_GPIO_FLOATING;
    gpio_init.odrv                           = MD_GPIO_OUT_DRIVE_NORMAL;
    gpio_init.flt                            = MD_GPIO_FILTER_DISABLE;
    gpio_init.type                           = MD_GPIO_TYPE_CMOS;
    gpio_init.func                           = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOB,MD_GPIO_PIN_4,&gpio_init);

    md_gpio_set_interrupt_port(GPIOB,MD_GPIO_PIN_4);
    md_gpio_enable_trailing_edge_trigger(MD_GPIO_PIN_4);
    md_gpio_disable_riging_edge_trigger(MD_GPIO_PIN_4);
    md_gpio_interrupt_filter_disable(MD_GPIO_PIN_4);
    md_gpio_interrupt_filter_time_set(0);
    md_gpio_enable_external_interrupt(MD_GPIO_PIN_4);
    /* USER CODE BEGIN init_gpio 1 */

    /* USER CODE END init_gpio 1 */
    
}
/**
  * @brief  Initializate pis function
  * @param  None
  * @retval None
  */
void init_pis(void)
{    
    /* USER CODE BEGIN init_pis 0 */

    /* USER CODE END init_pis 0 */
    
    md_pis_init_t pis_init;
    /* Initialize pis */
    memset(&pis_init, 0, sizeof(md_pis_init_t));

    /* USER CODE BEGIN init_pis 1 */

    /* USER CODE END init_pis 1 */
    
}
/**
  * @brief  Initializate dma function
  * @param  None
  * @retval None
  */
void init_dma(void)
{    
    /* USER CODE BEGIN init_dma 0 */

    /* USER CODE END init_dma 0 */
    
    md_dma_config_t dma_init;
    /* Initialize dma */
    memset(&dma_init, 0x0, sizeof(md_dma_config_t));

    dma_init.src                            = NULL;
    dma_init.dst                            = NULL;
    dma_init.size                           = 0;
    dma_init.src_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.dst_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.src_inc                        = DISABLE;
    dma_init.dst_inc                        = DISABLE;
    dma_init.R_power                        = MD_DMA_R_POWER_1;
    dma_init.priority                       = MD_DMA_LOW_PRIORITY;
    dma_init.mem_to_mem                     = DISABLE;
    dma_init.circle_mode                    = DISABLE;
    dma_init.msel                           = MD_DMA_MSEL_SPI0;
    dma_init.msigsel                        = MD_DMA_MSIGSEL_SPI_TXEMPTY;
    md_dma_init(MD_DMA_CH_4,&dma_init);

    dma_init.src                            = NULL;
    dma_init.dst                            = NULL;
    dma_init.size                           = 0;
    dma_init.src_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.dst_data_width                 = MD_DMA_DATA_SIZE_HALFWORD;
    dma_init.src_inc                        = DISABLE;
    dma_init.dst_inc                        = DISABLE;
    dma_init.R_power                        = MD_DMA_R_POWER_1;
    dma_init.priority                       = MD_DMA_LOW_PRIORITY;
    dma_init.mem_to_mem                     = DISABLE;
    dma_init.circle_mode                    = DISABLE;
    dma_init.msel                           = MD_DMA_MSEL_SPI1;
    dma_init.msigsel                        = MD_DMA_MSIGSEL_SPI_TXEMPTY;
    md_dma_init(MD_DMA_CH_5,&dma_init);

    /* USER CODE BEGIN init_dma 1 */

    /* USER CODE END init_dma 1 */
    
}
/**
  * @brief  Initializate spi0 function
  * @param  None
  * @retval None
  */
void init_spi0(void)
{    
    /* USER CODE BEGIN init_spi0 0 */

    /* USER CODE END init_spi0 0 */
    
    md_spi_init_t spi0_init;
    md_spi_struct_init(&spi0_init);
    /* Initialize spi0 */
    spi0_init.SPIx                           = SPI0;
    spi0_init.mode                           = MD_SPI_MODE_MASTER;
    spi0_init.dir                            = MD_SPI_DIRECTION_2LINES;
    spi0_init.data_size                      = MD_SPI_DATA_SIZE_8;
    spi0_init.baud                           = MD_SPI_BAUD_2;
    spi0_init.phase                          = MD_SPI_CPHA_SECOND;
    spi0_init.polarity                       = MD_SPI_CPOL_HIGH;
    spi0_init.first_bit                      = MD_SPI_FIRSTBIT_MSB;
    spi0_init.ss_en                          = DISABLE;
    spi0_init.crc_calc                       = DISABLE;
    spi0_init.frame                          = MD_SPI_FRAME_MOTOROLA;
    spi0_init.crc_poly                       = 7;
    md_spi_init(&spi0_init);

    
    /* USER CODE BEGIN init_spi0 1 */

    /* USER CODE END init_spi0 1 */
    
}
/**
  * @brief  Initializate spi1 function
  * @param  None
  * @retval None
  */
void init_spi1(void)
{    
    /* USER CODE BEGIN init_spi1 0 */

    /* USER CODE END init_spi1 0 */
    
    md_spi_init_t spi1_init;
    md_spi_struct_init(&spi1_init);
    /* Initialize spi1 */
    spi1_init.SPIx                           = SPI1;
    spi1_init.mode                           = MD_SPI_MODE_MASTER;
    spi1_init.dir                            = MD_SPI_DIRECTION_2LINES;
    spi1_init.data_size                      = MD_SPI_DATA_SIZE_8;
    spi1_init.baud                           = MD_SPI_BAUD_2;
    spi1_init.phase                          = MD_SPI_CPHA_SECOND;
    spi1_init.polarity                       = MD_SPI_CPOL_HIGH;
    spi1_init.first_bit                      = MD_SPI_FIRSTBIT_MSB;
    spi1_init.ss_en                          = DISABLE;
    spi1_init.crc_calc                       = DISABLE;
    spi1_init.frame                          = MD_SPI_FRAME_MOTOROLA;
    spi1_init.crc_poly                       = 7;
    md_spi_init(&spi1_init);

    
    /* USER CODE BEGIN init_spi1 1 */

    /* USER CODE END init_spi1 1 */
    
}
/**
  * @brief  Initializate cuart0 function
  * @param  None
  * @retval None
  */
void init_cuart0(void)
{    
    /* USER CODE BEGIN init_cuart0 0 */
    
    /* USER CODE END init_cuart0 0 */
    
    md_uart_init_t cuart0_init;
    md_uart_init_struct(&cuart0_init);
    /* Initialize cuart0 */
    cuart0_init.baud                           = 115200;
    cuart0_init.word_length                    = MD_UART_WORD_LENGTH_8B;
    cuart0_init.stop_bits                      = MD_UART_STOP_BITS_1;
    cuart0_init.parity                         = MD_UART_PARITY_NONE;
    cuart0_init.fctl                           = MD_UART_FLOW_CTL_DISABLE;
    cuart0_init.mode                           = MD_UART_MODE;
    md_uart_init(CUART0,&cuart0_init);

    
    /* USER CODE BEGIN init_cuart0 1 */
    
    /* USER CODE END init_cuart0 1 */
    
}
/**
  * @brief  Main function
  * @retval Status.
 */
int main(void)
{
    /* USER CODE BEGIN 1 */

    /* USER CODE END 1 */
    
    __disable_irq();
    /* Initialize cmu */
    init_cmu();

    /* Initialize mcu */
    init_mcu();

    /* Initialize gpio */
    init_gpio();

    /* Initialize pis */
    init_pis();

    /* Initialize dma */
    init_dma();

    /* Initialize spi0 */
    init_spi0();

    /* Initialize spi1 */
    init_spi1();

    /* Initialize cuart0 */
    init_cuart0();

    __enable_irq();


    /* Initialize mid gui */
    gui_main_init();

    /* USER CODE BEGIN 2 */

    user_ui_events_init();
    
    g_key1_flag = 0;
    g_key2_flag = 0;
    g_test_key_state = 0;
    /* USER CODE END 2 */
    
    while (1)
    {
        /* handle mid gui */
        gui_main_loop();

        /* USER CODE BEGIN 3 */
        
        if(g_key1_flag)
        {
            g_key1_flag = 0;
            es_test_select_next_obj_in_screen();
        }
        
        if(g_key2_flag)
        {
            g_key2_flag = 0;
            g_test_key_state = 1;
        }
        
        if(g_test_key_state)
        {
            if(md_gpio_get_input_data(GPIOB,MD_GPIO_PIN_4))
            {
                g_test_key_state = 0;
                es_test_change_select_obj();
            }
            else
            {
                if(g_test_key_state == 1)
                {
                    g_test_key_state = 2;
                    es_test_change_select_obj();
                }
            }
        }
        
        /* USER CODE END 3 */
        
    }
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  printf _write function
  * @retval len
  */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt;
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        cnt = 4000;

        while ((READ_BIT(CUART0->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK
                && (--cnt))
        {
        }

        WRITE_REG(CUART0->TXBUF, *ptr_char++);
    }

    return len;
}


/* USER CODE BEGIN 5 */

/* USER CODE END 5 */


/**
  * @}
  */
/**
  * @}
  */
/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
